package oos

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateExecution invokes the oos.UpdateExecution API synchronously
func (client *Client) UpdateExecution(request *UpdateExecutionRequest) (response *UpdateExecutionResponse, err error) {
	response = CreateUpdateExecutionResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateExecutionWithChan invokes the oos.UpdateExecution API asynchronously
func (client *Client) UpdateExecutionWithChan(request *UpdateExecutionRequest) (<-chan *UpdateExecutionResponse, <-chan error) {
	responseChan := make(chan *UpdateExecutionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateExecution(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateExecutionWithCallback invokes the oos.UpdateExecution API asynchronously
func (client *Client) UpdateExecutionWithCallback(request *UpdateExecutionRequest, callback func(response *UpdateExecutionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateExecutionResponse
		var err error
		defer close(result)
		response, err = client.UpdateExecution(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateExecutionRequest is the request struct for api UpdateExecution
type UpdateExecutionRequest struct {
	*requests.RpcRequest
	ClientToken     string `position:"Query" name:"ClientToken"`
	Description     string `position:"Query" name:"Description"`
	Tags            string `position:"Query" name:"Tags"`
	ExecutionId     string `position:"Query" name:"ExecutionId"`
	ResourceGroupId string `position:"Query" name:"ResourceGroupId"`
	Parameters      string `position:"Query" name:"Parameters"`
}

// UpdateExecutionResponse is the response struct for api UpdateExecution
type UpdateExecutionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateExecutionRequest creates a request to invoke UpdateExecution API
func CreateUpdateExecutionRequest() (request *UpdateExecutionRequest) {
	request = &UpdateExecutionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("oos", "2019-06-01", "UpdateExecution", "oos", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateExecutionResponse creates a response to parse from UpdateExecution response
func CreateUpdateExecutionResponse() (response *UpdateExecutionResponse) {
	response = &UpdateExecutionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
