package oos

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListParameterVersions invokes the oos.ListParameterVersions API synchronously
func (client *Client) ListParameterVersions(request *ListParameterVersionsRequest) (response *ListParameterVersionsResponse, err error) {
	response = CreateListParameterVersionsResponse()
	err = client.DoAction(request, response)
	return
}

// ListParameterVersionsWithChan invokes the oos.ListParameterVersions API asynchronously
func (client *Client) ListParameterVersionsWithChan(request *ListParameterVersionsRequest) (<-chan *ListParameterVersionsResponse, <-chan error) {
	responseChan := make(chan *ListParameterVersionsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListParameterVersions(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListParameterVersionsWithCallback invokes the oos.ListParameterVersions API asynchronously
func (client *Client) ListParameterVersionsWithCallback(request *ListParameterVersionsRequest, callback func(response *ListParameterVersionsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListParameterVersionsResponse
		var err error
		defer close(result)
		response, err = client.ListParameterVersions(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListParameterVersionsRequest is the request struct for api ListParameterVersions
type ListParameterVersionsRequest struct {
	*requests.RpcRequest
	NextToken  string           `position:"Query" name:"NextToken"`
	Name       string           `position:"Query" name:"Name"`
	MaxResults requests.Integer `position:"Query" name:"MaxResults"`
	ShareType  string           `position:"Query" name:"ShareType"`
}

// ListParameterVersionsResponse is the response struct for api ListParameterVersions
type ListParameterVersionsResponse struct {
	*responses.BaseResponse
	Type              string             `json:"Type" xml:"Type"`
	NextToken         string             `json:"NextToken" xml:"NextToken"`
	RequestId         string             `json:"RequestId" xml:"RequestId"`
	Description       string             `json:"Description" xml:"Description"`
	MaxResults        int                `json:"MaxResults" xml:"MaxResults"`
	CreatedBy         string             `json:"CreatedBy" xml:"CreatedBy"`
	CreatedDate       string             `json:"CreatedDate" xml:"CreatedDate"`
	Name              string             `json:"Name" xml:"Name"`
	TotalCount        int                `json:"TotalCount" xml:"TotalCount"`
	Id                string             `json:"Id" xml:"Id"`
	ParameterVersions []ParameterVersion `json:"ParameterVersions" xml:"ParameterVersions"`
}

// CreateListParameterVersionsRequest creates a request to invoke ListParameterVersions API
func CreateListParameterVersionsRequest() (request *ListParameterVersionsRequest) {
	request = &ListParameterVersionsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("oos", "2019-06-01", "ListParameterVersions", "oos", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListParameterVersionsResponse creates a response to parse from ListParameterVersions response
func CreateListParameterVersionsResponse() (response *ListParameterVersionsResponse) {
	response = &ListParameterVersionsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
