package oos

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteExecutions invokes the oos.DeleteExecutions API synchronously
func (client *Client) DeleteExecutions(request *DeleteExecutionsRequest) (response *DeleteExecutionsResponse, err error) {
	response = CreateDeleteExecutionsResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteExecutionsWithChan invokes the oos.DeleteExecutions API asynchronously
func (client *Client) DeleteExecutionsWithChan(request *DeleteExecutionsRequest) (<-chan *DeleteExecutionsResponse, <-chan error) {
	responseChan := make(chan *DeleteExecutionsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteExecutions(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteExecutionsWithCallback invokes the oos.DeleteExecutions API asynchronously
func (client *Client) DeleteExecutionsWithCallback(request *DeleteExecutionsRequest, callback func(response *DeleteExecutionsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteExecutionsResponse
		var err error
		defer close(result)
		response, err = client.DeleteExecutions(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteExecutionsRequest is the request struct for api DeleteExecutions
type DeleteExecutionsRequest struct {
	*requests.RpcRequest
	ExecutionIds string `position:"Query" name:"ExecutionIds"`
}

// DeleteExecutionsResponse is the response struct for api DeleteExecutions
type DeleteExecutionsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteExecutionsRequest creates a request to invoke DeleteExecutions API
func CreateDeleteExecutionsRequest() (request *DeleteExecutionsRequest) {
	request = &DeleteExecutionsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("oos", "2019-06-01", "DeleteExecutions", "oos", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteExecutionsResponse creates a response to parse from DeleteExecutions response
func CreateDeleteExecutionsResponse() (response *DeleteExecutionsResponse) {
	response = &DeleteExecutionsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
