package oms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteDomainPart invokes the oms.DeleteDomainPart API synchronously
func (client *Client) DeleteDomainPart(request *DeleteDomainPartRequest) (response *DeleteDomainPartResponse, err error) {
	response = CreateDeleteDomainPartResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteDomainPartWithChan invokes the oms.DeleteDomainPart API asynchronously
func (client *Client) DeleteDomainPartWithChan(request *DeleteDomainPartRequest) (<-chan *DeleteDomainPartResponse, <-chan error) {
	responseChan := make(chan *DeleteDomainPartResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteDomainPart(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteDomainPartWithCallback invokes the oms.DeleteDomainPart API asynchronously
func (client *Client) DeleteDomainPartWithCallback(request *DeleteDomainPartRequest, callback func(response *DeleteDomainPartResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteDomainPartResponse
		var err error
		defer close(result)
		response, err = client.DeleteDomainPart(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteDomainPartRequest is the request struct for api DeleteDomainPart
type DeleteDomainPartRequest struct {
	*requests.RpcRequest
	DomainCode string `position:"Query" name:"DomainCode"`
	DataType   string `position:"Query" name:"DataType"`
	Part       string `position:"Query" name:"Part"`
}

// DeleteDomainPartResponse is the response struct for api DeleteDomainPart
type DeleteDomainPartResponse struct {
	*responses.BaseResponse
	DataType   string `json:"DataType" xml:"DataType"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
	DomainCode string `json:"DomainCode" xml:"DomainCode"`
}

// CreateDeleteDomainPartRequest creates a request to invoke DeleteDomainPart API
func CreateDeleteDomainPartRequest() (request *DeleteDomainPartRequest) {
	request = &DeleteDomainPartRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Oms", "2016-06-15", "DeleteDomainPart", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteDomainPartResponse creates a response to parse from DeleteDomainPart response
func CreateDeleteDomainPartResponse() (response *DeleteDomainPartResponse) {
	response = &DeleteDomainPartResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
