package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SwitchoverInstance invokes the oceanbasepro.SwitchoverInstance API synchronously
func (client *Client) SwitchoverInstance(request *SwitchoverInstanceRequest) (response *SwitchoverInstanceResponse, err error) {
	response = CreateSwitchoverInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// SwitchoverInstanceWithChan invokes the oceanbasepro.SwitchoverInstance API asynchronously
func (client *Client) SwitchoverInstanceWithChan(request *SwitchoverInstanceRequest) (<-chan *SwitchoverInstanceResponse, <-chan error) {
	responseChan := make(chan *SwitchoverInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SwitchoverInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SwitchoverInstanceWithCallback invokes the oceanbasepro.SwitchoverInstance API asynchronously
func (client *Client) SwitchoverInstanceWithCallback(request *SwitchoverInstanceRequest, callback func(response *SwitchoverInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SwitchoverInstanceResponse
		var err error
		defer close(result)
		response, err = client.SwitchoverInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SwitchoverInstanceRequest is the request struct for api SwitchoverInstance
type SwitchoverInstanceRequest struct {
	*requests.RpcRequest
	Forced           requests.Boolean `position:"Body" name:"Forced"`
	InstanceId       string           `position:"Body" name:"InstanceId"`
	TargetInstanceId string           `position:"Body" name:"TargetInstanceId"`
}

// SwitchoverInstanceResponse is the response struct for api SwitchoverInstance
type SwitchoverInstanceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateSwitchoverInstanceRequest creates a request to invoke SwitchoverInstance API
func CreateSwitchoverInstanceRequest() (request *SwitchoverInstanceRequest) {
	request = &SwitchoverInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "SwitchoverInstance", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSwitchoverInstanceResponse creates a response to parse from SwitchoverInstance response
func CreateSwitchoverInstanceResponse() (response *SwitchoverInstanceResponse) {
	response = &SwitchoverInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
