package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAvailableZone invokes the oceanbasepro.DescribeAvailableZone API synchronously
func (client *Client) DescribeAvailableZone(request *DescribeAvailableZoneRequest) (response *DescribeAvailableZoneResponse, err error) {
	response = CreateDescribeAvailableZoneResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAvailableZoneWithChan invokes the oceanbasepro.DescribeAvailableZone API asynchronously
func (client *Client) DescribeAvailableZoneWithChan(request *DescribeAvailableZoneRequest) (<-chan *DescribeAvailableZoneResponse, <-chan error) {
	responseChan := make(chan *DescribeAvailableZoneResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAvailableZone(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAvailableZoneWithCallback invokes the oceanbasepro.DescribeAvailableZone API asynchronously
func (client *Client) DescribeAvailableZoneWithCallback(request *DescribeAvailableZoneRequest, callback func(response *DescribeAvailableZoneResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAvailableZoneResponse
		var err error
		defer close(result)
		response, err = client.DescribeAvailableZone(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAvailableZoneRequest is the request struct for api DescribeAvailableZone
type DescribeAvailableZoneRequest struct {
	*requests.RpcRequest
	Spec         string `position:"Body" name:"Spec"`
	InstanceType string `position:"Body" name:"InstanceType"`
	ObVersion    string `position:"Body" name:"ObVersion"`
	Series       string `position:"Body" name:"Series"`
	CpuArch      string `position:"Body" name:"CpuArch"`
	DeployType   string `position:"Body" name:"DeployType"`
}

// DescribeAvailableZoneResponse is the response struct for api DescribeAvailableZone
type DescribeAvailableZoneResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDescribeAvailableZoneRequest creates a request to invoke DescribeAvailableZone API
func CreateDescribeAvailableZoneRequest() (request *DescribeAvailableZoneRequest) {
	request = &DescribeAvailableZoneRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "DescribeAvailableZone", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeAvailableZoneResponse creates a response to parse from DescribeAvailableZone response
func CreateDescribeAvailableZoneResponse() (response *DescribeAvailableZoneResponse) {
	response = &DescribeAvailableZoneResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
