package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteSecurityIpGroup invokes the oceanbasepro.DeleteSecurityIpGroup API synchronously
func (client *Client) DeleteSecurityIpGroup(request *DeleteSecurityIpGroupRequest) (response *DeleteSecurityIpGroupResponse, err error) {
	response = CreateDeleteSecurityIpGroupResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteSecurityIpGroupWithChan invokes the oceanbasepro.DeleteSecurityIpGroup API asynchronously
func (client *Client) DeleteSecurityIpGroupWithChan(request *DeleteSecurityIpGroupRequest) (<-chan *DeleteSecurityIpGroupResponse, <-chan error) {
	responseChan := make(chan *DeleteSecurityIpGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteSecurityIpGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteSecurityIpGroupWithCallback invokes the oceanbasepro.DeleteSecurityIpGroup API asynchronously
func (client *Client) DeleteSecurityIpGroupWithCallback(request *DeleteSecurityIpGroupRequest, callback func(response *DeleteSecurityIpGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteSecurityIpGroupResponse
		var err error
		defer close(result)
		response, err = client.DeleteSecurityIpGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteSecurityIpGroupRequest is the request struct for api DeleteSecurityIpGroup
type DeleteSecurityIpGroupRequest struct {
	*requests.RpcRequest
	SecurityIpGroupName string `position:"Body" name:"SecurityIpGroupName"`
	InstanceId          string `position:"Body" name:"InstanceId"`
}

// DeleteSecurityIpGroupResponse is the response struct for api DeleteSecurityIpGroup
type DeleteSecurityIpGroupResponse struct {
	*responses.BaseResponse
	RequestId       string          `json:"RequestId" xml:"RequestId"`
	SecurityIpGroup SecurityIpGroup `json:"SecurityIpGroup" xml:"SecurityIpGroup"`
}

// CreateDeleteSecurityIpGroupRequest creates a request to invoke DeleteSecurityIpGroup API
func CreateDeleteSecurityIpGroupRequest() (request *DeleteSecurityIpGroupRequest) {
	request = &DeleteSecurityIpGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "DeleteSecurityIpGroup", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteSecurityIpGroupResponse creates a response to parse from DeleteSecurityIpGroup response
func CreateDeleteSecurityIpGroupResponse() (response *DeleteSecurityIpGroupResponse) {
	response = &DeleteSecurityIpGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
