package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryTraceM3u8Job invokes the mts.QueryTraceM3u8Job API synchronously
func (client *Client) QueryTraceM3u8Job(request *QueryTraceM3u8JobRequest) (response *QueryTraceM3u8JobResponse, err error) {
	response = CreateQueryTraceM3u8JobResponse()
	err = client.DoAction(request, response)
	return
}

// QueryTraceM3u8JobWithChan invokes the mts.QueryTraceM3u8Job API asynchronously
func (client *Client) QueryTraceM3u8JobWithChan(request *QueryTraceM3u8JobRequest) (<-chan *QueryTraceM3u8JobResponse, <-chan error) {
	responseChan := make(chan *QueryTraceM3u8JobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryTraceM3u8Job(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryTraceM3u8JobWithCallback invokes the mts.QueryTraceM3u8Job API asynchronously
func (client *Client) QueryTraceM3u8JobWithCallback(request *QueryTraceM3u8JobRequest, callback func(response *QueryTraceM3u8JobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryTraceM3u8JobResponse
		var err error
		defer close(result)
		response, err = client.QueryTraceM3u8Job(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryTraceM3u8JobRequest is the request struct for api QueryTraceM3u8Job
type QueryTraceM3u8JobRequest struct {
	*requests.RpcRequest
	Level           requests.Integer `position:"Query" name:"Level"`
	MessageId       requests.Integer `position:"Query" name:"MessageId"`
	PageNumber      requests.Integer `position:"Query" name:"PageNumber"`
	CreateTimeEnd   requests.Integer `position:"Query" name:"CreateTimeEnd"`
	JobId           string           `position:"Query" name:"JobId"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	CreateTimeStart requests.Integer `position:"Query" name:"CreateTimeStart"`
}

// QueryTraceM3u8JobResponse is the response struct for api QueryTraceM3u8Job
type QueryTraceM3u8JobResponse struct {
	*responses.BaseResponse
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	Message    string     `json:"Message" xml:"Message"`
	StatusCode int64      `json:"StatusCode" xml:"StatusCode"`
	Data       []DataItem `json:"Data" xml:"Data"`
}

// CreateQueryTraceM3u8JobRequest creates a request to invoke QueryTraceM3u8Job API
func CreateQueryTraceM3u8JobRequest() (request *QueryTraceM3u8JobRequest) {
	request = &QueryTraceM3u8JobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "QueryTraceM3u8Job", "mts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryTraceM3u8JobResponse creates a response to parse from QueryTraceM3u8Job response
func CreateQueryTraceM3u8JobResponse() (response *QueryTraceM3u8JobResponse) {
	response = &QueryTraceM3u8JobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
