package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListCustomPersons invokes the mts.ListCustomPersons API synchronously
func (client *Client) ListCustomPersons(request *ListCustomPersonsRequest) (response *ListCustomPersonsResponse, err error) {
	response = CreateListCustomPersonsResponse()
	err = client.DoAction(request, response)
	return
}

// ListCustomPersonsWithChan invokes the mts.ListCustomPersons API asynchronously
func (client *Client) ListCustomPersonsWithChan(request *ListCustomPersonsRequest) (<-chan *ListCustomPersonsResponse, <-chan error) {
	responseChan := make(chan *ListCustomPersonsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListCustomPersons(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListCustomPersonsWithCallback invokes the mts.ListCustomPersons API asynchronously
func (client *Client) ListCustomPersonsWithCallback(request *ListCustomPersonsRequest, callback func(response *ListCustomPersonsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListCustomPersonsResponse
		var err error
		defer close(result)
		response, err = client.ListCustomPersons(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListCustomPersonsRequest is the request struct for api ListCustomPersons
type ListCustomPersonsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PersonId             string           `position:"Query" name:"PersonId"`
	CategoryId           string           `position:"Query" name:"CategoryId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// ListCustomPersonsResponse is the response struct for api ListCustomPersons
type ListCustomPersonsResponse struct {
	*responses.BaseResponse
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	Categories Categories `json:"Categories" xml:"Categories"`
}

// CreateListCustomPersonsRequest creates a request to invoke ListCustomPersons API
func CreateListCustomPersonsRequest() (request *ListCustomPersonsRequest) {
	request = &ListCustomPersonsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "ListCustomPersons", "mts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListCustomPersonsResponse creates a response to parse from ListCustomPersons response
func CreateListCustomPersonsResponse() (response *ListCustomPersonsResponse) {
	response = &ListCustomPersonsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
