package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateAuthPolicy invokes the mse.UpdateAuthPolicy API synchronously
func (client *Client) UpdateAuthPolicy(request *UpdateAuthPolicyRequest) (response *UpdateAuthPolicyResponse, err error) {
	response = CreateUpdateAuthPolicyResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateAuthPolicyWithChan invokes the mse.UpdateAuthPolicy API asynchronously
func (client *Client) UpdateAuthPolicyWithChan(request *UpdateAuthPolicyRequest) (<-chan *UpdateAuthPolicyResponse, <-chan error) {
	responseChan := make(chan *UpdateAuthPolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateAuthPolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateAuthPolicyWithCallback invokes the mse.UpdateAuthPolicy API asynchronously
func (client *Client) UpdateAuthPolicyWithCallback(request *UpdateAuthPolicyRequest, callback func(response *UpdateAuthPolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateAuthPolicyResponse
		var err error
		defer close(result)
		response, err = client.UpdateAuthPolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateAuthPolicyRequest is the request struct for api UpdateAuthPolicy
type UpdateAuthPolicyRequest struct {
	*requests.RpcRequest
	MseSessionId   string `position:"Query" name:"MseSessionId"`
	AuthRule       string `position:"Query" name:"AuthRule"`
	Source         string `position:"Query" name:"Source"`
	Protocol       string `position:"Query" name:"Protocol"`
	Enable         string `position:"Query" name:"Enable"`
	Id             string `position:"Query" name:"Id"`
	K8sNamespace   string `position:"Query" name:"K8sNamespace"`
	AppId          string `position:"Query" name:"AppId"`
	Name           string `position:"Query" name:"Name"`
	AcceptLanguage string `position:"Query" name:"AcceptLanguage"`
	Region         string `position:"Query" name:"Region"`
}

// UpdateAuthPolicyResponse is the response struct for api UpdateAuthPolicy
type UpdateAuthPolicyResponse struct {
	*responses.BaseResponse
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Message        string `json:"Message" xml:"Message"`
	Data           string `json:"Data" xml:"Data"`
	Code           int    `json:"Code" xml:"Code"`
	Success        bool   `json:"Success" xml:"Success"`
}

// CreateUpdateAuthPolicyRequest creates a request to invoke UpdateAuthPolicy API
func CreateUpdateAuthPolicyRequest() (request *UpdateAuthPolicyRequest) {
	request = &UpdateAuthPolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "UpdateAuthPolicy", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateAuthPolicyResponse creates a response to parse from UpdateAuthPolicy response
func CreateUpdateAuthPolicyResponse() (response *UpdateAuthPolicyResponse) {
	response = &UpdateAuthPolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
