package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EnableProxyProtocol invokes the mse.EnableProxyProtocol API synchronously
func (client *Client) EnableProxyProtocol(request *EnableProxyProtocolRequest) (response *EnableProxyProtocolResponse, err error) {
	response = CreateEnableProxyProtocolResponse()
	err = client.DoAction(request, response)
	return
}

// EnableProxyProtocolWithChan invokes the mse.EnableProxyProtocol API asynchronously
func (client *Client) EnableProxyProtocolWithChan(request *EnableProxyProtocolRequest) (<-chan *EnableProxyProtocolResponse, <-chan error) {
	responseChan := make(chan *EnableProxyProtocolResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EnableProxyProtocol(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EnableProxyProtocolWithCallback invokes the mse.EnableProxyProtocol API asynchronously
func (client *Client) EnableProxyProtocolWithCallback(request *EnableProxyProtocolRequest, callback func(response *EnableProxyProtocolResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EnableProxyProtocolResponse
		var err error
		defer close(result)
		response, err = client.EnableProxyProtocol(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EnableProxyProtocolRequest is the request struct for api EnableProxyProtocol
type EnableProxyProtocolRequest struct {
	*requests.RpcRequest
	MseSessionId        string           `position:"Query" name:"MseSessionId"`
	GatewayUniqueId     string           `position:"Query" name:"GatewayUniqueId"`
	EnableProxyProtocol requests.Boolean `position:"Query" name:"EnableProxyProtocol"`
	AcceptLanguage      string           `position:"Query" name:"AcceptLanguage"`
}

// EnableProxyProtocolResponse is the response struct for api EnableProxyProtocol
type EnableProxyProtocolResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           int    `json:"Code" xml:"Code"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	DynamicCode    string `json:"DynamicCode" xml:"DynamicCode"`
	DynamicMessage string `json:"DynamicMessage" xml:"DynamicMessage"`
	Data           bool   `json:"Data" xml:"Data"`
}

// CreateEnableProxyProtocolRequest creates a request to invoke EnableProxyProtocol API
func CreateEnableProxyProtocolRequest() (request *EnableProxyProtocolRequest) {
	request = &EnableProxyProtocolRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "EnableProxyProtocol", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateEnableProxyProtocolResponse creates a response to parse from EnableProxyProtocol response
func CreateEnableProxyProtocolResponse() (response *EnableProxyProtocolResponse) {
	response = &EnableProxyProtocolResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
