package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryPushAnalysisTaskList invokes the mpaas.QueryPushAnalysisTaskList API synchronously
func (client *Client) QueryPushAnalysisTaskList(request *QueryPushAnalysisTaskListRequest) (response *QueryPushAnalysisTaskListResponse, err error) {
	response = CreateQueryPushAnalysisTaskListResponse()
	err = client.DoAction(request, response)
	return
}

// QueryPushAnalysisTaskListWithChan invokes the mpaas.QueryPushAnalysisTaskList API asynchronously
func (client *Client) QueryPushAnalysisTaskListWithChan(request *QueryPushAnalysisTaskListRequest) (<-chan *QueryPushAnalysisTaskListResponse, <-chan error) {
	responseChan := make(chan *QueryPushAnalysisTaskListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryPushAnalysisTaskList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryPushAnalysisTaskListWithCallback invokes the mpaas.QueryPushAnalysisTaskList API asynchronously
func (client *Client) QueryPushAnalysisTaskListWithCallback(request *QueryPushAnalysisTaskListRequest, callback func(response *QueryPushAnalysisTaskListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryPushAnalysisTaskListResponse
		var err error
		defer close(result)
		response, err = client.QueryPushAnalysisTaskList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryPushAnalysisTaskListRequest is the request struct for api QueryPushAnalysisTaskList
type QueryPushAnalysisTaskListRequest struct {
	*requests.RpcRequest
	TaskName    string           `position:"Body" name:"TaskName"`
	StartTime   requests.Integer `position:"Body" name:"StartTime"`
	PageNumber  requests.Integer `position:"Body" name:"PageNumber"`
	PageSize    requests.Integer `position:"Body" name:"PageSize"`
	TaskId      string           `position:"Body" name:"TaskId"`
	AppId       string           `position:"Body" name:"AppId"`
	WorkspaceId string           `position:"Body" name:"WorkspaceId"`
}

// QueryPushAnalysisTaskListResponse is the response struct for api QueryPushAnalysisTaskList
type QueryPushAnalysisTaskListResponse struct {
	*responses.BaseResponse
	ResultMessage string                                   `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode    string                                   `json:"ResultCode" xml:"ResultCode"`
	RequestId     string                                   `json:"RequestId" xml:"RequestId"`
	ResultContent ResultContentInQueryPushAnalysisTaskList `json:"ResultContent" xml:"ResultContent"`
}

// CreateQueryPushAnalysisTaskListRequest creates a request to invoke QueryPushAnalysisTaskList API
func CreateQueryPushAnalysisTaskListRequest() (request *QueryPushAnalysisTaskListRequest) {
	request = &QueryPushAnalysisTaskListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "QueryPushAnalysisTaskList", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryPushAnalysisTaskListResponse creates a response to parse from QueryPushAnalysisTaskList response
func CreateQueryPushAnalysisTaskListResponse() (response *QueryPushAnalysisTaskListResponse) {
	response = &QueryPushAnalysisTaskListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
