package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryMgsApipage invokes the mpaas.QueryMgsApipage API synchronously
func (client *Client) QueryMgsApipage(request *QueryMgsApipageRequest) (response *QueryMgsApipageResponse, err error) {
	response = CreateQueryMgsApipageResponse()
	err = client.DoAction(request, response)
	return
}

// QueryMgsApipageWithChan invokes the mpaas.QueryMgsApipage API asynchronously
func (client *Client) QueryMgsApipageWithChan(request *QueryMgsApipageRequest) (<-chan *QueryMgsApipageResponse, <-chan error) {
	responseChan := make(chan *QueryMgsApipageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryMgsApipage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryMgsApipageWithCallback invokes the mpaas.QueryMgsApipage API asynchronously
func (client *Client) QueryMgsApipageWithCallback(request *QueryMgsApipageRequest, callback func(response *QueryMgsApipageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryMgsApipageResponse
		var err error
		defer close(result)
		response, err = client.QueryMgsApipage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryMgsApipageRequest is the request struct for api QueryMgsApipage
type QueryMgsApipageRequest struct {
	*requests.RpcRequest
	NeedEtag      string           `position:"Body" name:"NeedEtag"`
	ApiType       string           `position:"Body" name:"ApiType"`
	OptFuzzy      string           `position:"Body" name:"OptFuzzy"`
	Host          string           `position:"Body" name:"Host"`
	PageSize      requests.Integer `position:"Body" name:"PageSize"`
	TenantId      string           `position:"Body" name:"TenantId"`
	PageIndex     requests.Integer `position:"Body" name:"PageIndex"`
	ApiStatus     string           `position:"Body" name:"ApiStatus"`
	SysId         requests.Integer `position:"Body" name:"SysId"`
	Format        string           `position:"Body" name:"Format"`
	NeedEncrypt   string           `position:"Body" name:"NeedEncrypt"`
	OperationType string           `position:"Body" name:"OperationType"`
	NeedSign      string           `position:"Body" name:"NeedSign"`
	AppId         string           `position:"Body" name:"AppId"`
	SysName       string           `position:"Body" name:"SysName"`
	WorkspaceId   string           `position:"Body" name:"WorkspaceId"`
}

// QueryMgsApipageResponse is the response struct for api QueryMgsApipage
type QueryMgsApipageResponse struct {
	*responses.BaseResponse
	ResultMessage string        `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode    string        `json:"ResultCode" xml:"ResultCode"`
	RequestId     string        `json:"RequestId" xml:"RequestId"`
	ResultContent ResultContent `json:"ResultContent" xml:"ResultContent"`
}

// CreateQueryMgsApipageRequest creates a request to invoke QueryMgsApipage API
func CreateQueryMgsApipageRequest() (request *QueryMgsApipageRequest) {
	request = &QueryMgsApipageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "QueryMgsApipage", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryMgsApipageResponse creates a response to parse from QueryMgsApipage response
func CreateQueryMgsApipageResponse() (response *QueryMgsApipageResponse) {
	response = &QueryMgsApipageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
