package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryMappCenterApp invokes the mpaas.QueryMappCenterApp API synchronously
func (client *Client) QueryMappCenterApp(request *QueryMappCenterAppRequest) (response *QueryMappCenterAppResponse, err error) {
	response = CreateQueryMappCenterAppResponse()
	err = client.DoAction(request, response)
	return
}

// QueryMappCenterAppWithChan invokes the mpaas.QueryMappCenterApp API asynchronously
func (client *Client) QueryMappCenterAppWithChan(request *QueryMappCenterAppRequest) (<-chan *QueryMappCenterAppResponse, <-chan error) {
	responseChan := make(chan *QueryMappCenterAppResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryMappCenterApp(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryMappCenterAppWithCallback invokes the mpaas.QueryMappCenterApp API asynchronously
func (client *Client) QueryMappCenterAppWithCallback(request *QueryMappCenterAppRequest, callback func(response *QueryMappCenterAppResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryMappCenterAppResponse
		var err error
		defer close(result)
		response, err = client.QueryMappCenterApp(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryMappCenterAppRequest is the request struct for api QueryMappCenterApp
type QueryMappCenterAppRequest struct {
	*requests.RpcRequest
	AppId       string `position:"Body" name:"AppId"`
	WorkspaceId string `position:"Body" name:"WorkspaceId"`
}

// QueryMappCenterAppResponse is the response struct for api QueryMappCenterApp
type QueryMappCenterAppResponse struct {
	*responses.BaseResponse
	ResultMessage            string                   `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode               string                   `json:"ResultCode" xml:"ResultCode"`
	RequestId                string                   `json:"RequestId" xml:"RequestId"`
	QueryMappCenterAppResult QueryMappCenterAppResult `json:"QueryMappCenterAppResult" xml:"QueryMappCenterAppResult"`
}

// CreateQueryMappCenterAppRequest creates a request to invoke QueryMappCenterApp API
func CreateQueryMappCenterAppRequest() (request *QueryMappCenterAppRequest) {
	request = &QueryMappCenterAppRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "QueryMappCenterApp", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryMappCenterAppResponse creates a response to parse from QueryMappCenterApp response
func CreateQueryMappCenterAppResponse() (response *QueryMappCenterAppResponse) {
	response = &QueryMappCenterAppResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
