package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PushBind invokes the mpaas.PushBind API synchronously
func (client *Client) PushBind(request *PushBindRequest) (response *PushBindResponse, err error) {
	response = CreatePushBindResponse()
	err = client.DoAction(request, response)
	return
}

// PushBindWithChan invokes the mpaas.PushBind API asynchronously
func (client *Client) PushBindWithChan(request *PushBindRequest) (<-chan *PushBindResponse, <-chan error) {
	responseChan := make(chan *PushBindResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PushBind(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PushBindWithCallback invokes the mpaas.PushBind API asynchronously
func (client *Client) PushBindWithCallback(request *PushBindRequest, callback func(response *PushBindResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PushBindResponse
		var err error
		defer close(result)
		response, err = client.PushBind(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PushBindRequest is the request struct for api PushBind
type PushBindRequest struct {
	*requests.RpcRequest
	PhoneNumber   string           `position:"Body" name:"PhoneNumber"`
	UserId        string           `position:"Body" name:"UserId"`
	DeliveryToken string           `position:"Body" name:"DeliveryToken"`
	OsType        requests.Integer `position:"Body" name:"OsType"`
	AppId         string           `position:"Body" name:"AppId"`
	WorkspaceId   string           `position:"Body" name:"WorkspaceId"`
}

// PushBindResponse is the response struct for api PushBind
type PushBindResponse struct {
	*responses.BaseResponse
	ResultMessage string     `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode    string     `json:"ResultCode" xml:"ResultCode"`
	RequestId     string     `json:"RequestId" xml:"RequestId"`
	PushResult    PushResult `json:"PushResult" xml:"PushResult"`
}

// CreatePushBindRequest creates a request to invoke PushBind API
func CreatePushBindRequest() (request *PushBindRequest) {
	request = &PushBindRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "PushBind", "", "")
	request.Method = requests.POST
	return
}

// CreatePushBindResponse creates a response to parse from PushBind response
func CreatePushBindResponse() (response *PushBindResponse) {
	response = &PushBindResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
