package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OpenApiUpdateActiveCode invokes the mpaas.OpenApiUpdateActiveCode API synchronously
func (client *Client) OpenApiUpdateActiveCode(request *OpenApiUpdateActiveCodeRequest) (response *OpenApiUpdateActiveCodeResponse, err error) {
	response = CreateOpenApiUpdateActiveCodeResponse()
	err = client.DoAction(request, response)
	return
}

// OpenApiUpdateActiveCodeWithChan invokes the mpaas.OpenApiUpdateActiveCode API asynchronously
func (client *Client) OpenApiUpdateActiveCodeWithChan(request *OpenApiUpdateActiveCodeRequest) (<-chan *OpenApiUpdateActiveCodeResponse, <-chan error) {
	responseChan := make(chan *OpenApiUpdateActiveCodeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OpenApiUpdateActiveCode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OpenApiUpdateActiveCodeWithCallback invokes the mpaas.OpenApiUpdateActiveCode API asynchronously
func (client *Client) OpenApiUpdateActiveCodeWithCallback(request *OpenApiUpdateActiveCodeRequest, callback func(response *OpenApiUpdateActiveCodeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OpenApiUpdateActiveCodeResponse
		var err error
		defer close(result)
		response, err = client.OpenApiUpdateActiveCode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OpenApiUpdateActiveCodeRequest is the request struct for api OpenApiUpdateActiveCode
type OpenApiUpdateActiveCodeRequest struct {
	*requests.RpcRequest
	MpaasMqcpOpenApiUpdateActiveCodeReqJsonStr string `position:"Body" name:"MpaasMqcpOpenApiUpdateActiveCodeReqJsonStr"`
	TenantId                                   string `position:"Body" name:"TenantId"`
	AppId                                      string `position:"Body" name:"AppId"`
	WorkspaceId                                string `position:"Body" name:"WorkspaceId"`
}

// OpenApiUpdateActiveCodeResponse is the response struct for api OpenApiUpdateActiveCode
type OpenApiUpdateActiveCodeResponse struct {
	*responses.BaseResponse
	RequestId     string `json:"RequestId" xml:"RequestId"`
	ResultCode    string `json:"ResultCode" xml:"ResultCode"`
	ResultContent string `json:"ResultContent" xml:"ResultContent"`
}

// CreateOpenApiUpdateActiveCodeRequest creates a request to invoke OpenApiUpdateActiveCode API
func CreateOpenApiUpdateActiveCodeRequest() (request *OpenApiUpdateActiveCodeRequest) {
	request = &OpenApiUpdateActiveCodeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "OpenApiUpdateActiveCode", "", "")
	request.Method = requests.POST
	return
}

// CreateOpenApiUpdateActiveCodeResponse creates a response to parse from OpenApiUpdateActiveCode response
func CreateOpenApiUpdateActiveCodeResponse() (response *OpenApiUpdateActiveCodeResponse) {
	response = &OpenApiUpdateActiveCodeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
