package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListMcubeUpgradeTasks invokes the mpaas.ListMcubeUpgradeTasks API synchronously
func (client *Client) ListMcubeUpgradeTasks(request *ListMcubeUpgradeTasksRequest) (response *ListMcubeUpgradeTasksResponse, err error) {
	response = CreateListMcubeUpgradeTasksResponse()
	err = client.DoAction(request, response)
	return
}

// ListMcubeUpgradeTasksWithChan invokes the mpaas.ListMcubeUpgradeTasks API asynchronously
func (client *Client) ListMcubeUpgradeTasksWithChan(request *ListMcubeUpgradeTasksRequest) (<-chan *ListMcubeUpgradeTasksResponse, <-chan error) {
	responseChan := make(chan *ListMcubeUpgradeTasksResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListMcubeUpgradeTasks(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListMcubeUpgradeTasksWithCallback invokes the mpaas.ListMcubeUpgradeTasks API asynchronously
func (client *Client) ListMcubeUpgradeTasksWithCallback(request *ListMcubeUpgradeTasksRequest, callback func(response *ListMcubeUpgradeTasksResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListMcubeUpgradeTasksResponse
		var err error
		defer close(result)
		response, err = client.ListMcubeUpgradeTasks(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListMcubeUpgradeTasksRequest is the request struct for api ListMcubeUpgradeTasks
type ListMcubeUpgradeTasksRequest struct {
	*requests.RpcRequest
	PackageId   string `position:"Body" name:"PackageId"`
	TenantId    string `position:"Body" name:"TenantId"`
	AppId       string `position:"Body" name:"AppId"`
	WorkspaceId string `position:"Body" name:"WorkspaceId"`
}

// ListMcubeUpgradeTasksResponse is the response struct for api ListMcubeUpgradeTasks
type ListMcubeUpgradeTasksResponse struct {
	*responses.BaseResponse
	ResultMessage  string         `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode     string         `json:"ResultCode" xml:"ResultCode"`
	RequestId      string         `json:"RequestId" xml:"RequestId"`
	ListTaskResult ListTaskResult `json:"ListTaskResult" xml:"ListTaskResult"`
}

// CreateListMcubeUpgradeTasksRequest creates a request to invoke ListMcubeUpgradeTasks API
func CreateListMcubeUpgradeTasksRequest() (request *ListMcubeUpgradeTasksRequest) {
	request = &ListMcubeUpgradeTasksRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "ListMcubeUpgradeTasks", "", "")
	request.Method = requests.POST
	return
}

// CreateListMcubeUpgradeTasksResponse creates a response to parse from ListMcubeUpgradeTasks response
func CreateListMcubeUpgradeTasksResponse() (response *ListMcubeUpgradeTasksResponse) {
	response = &ListMcubeUpgradeTasksResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
