package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListMcubeNebulaTasks invokes the mpaas.ListMcubeNebulaTasks API synchronously
func (client *Client) ListMcubeNebulaTasks(request *ListMcubeNebulaTasksRequest) (response *ListMcubeNebulaTasksResponse, err error) {
	response = CreateListMcubeNebulaTasksResponse()
	err = client.DoAction(request, response)
	return
}

// ListMcubeNebulaTasksWithChan invokes the mpaas.ListMcubeNebulaTasks API asynchronously
func (client *Client) ListMcubeNebulaTasksWithChan(request *ListMcubeNebulaTasksRequest) (<-chan *ListMcubeNebulaTasksResponse, <-chan error) {
	responseChan := make(chan *ListMcubeNebulaTasksResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListMcubeNebulaTasks(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListMcubeNebulaTasksWithCallback invokes the mpaas.ListMcubeNebulaTasks API asynchronously
func (client *Client) ListMcubeNebulaTasksWithCallback(request *ListMcubeNebulaTasksRequest, callback func(response *ListMcubeNebulaTasksResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListMcubeNebulaTasksResponse
		var err error
		defer close(result)
		response, err = client.ListMcubeNebulaTasks(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListMcubeNebulaTasksRequest is the request struct for api ListMcubeNebulaTasks
type ListMcubeNebulaTasksRequest struct {
	*requests.RpcRequest
	TenantId    string           `position:"Body" name:"TenantId"`
	Id          requests.Integer `position:"Body" name:"Id"`
	AppId       string           `position:"Body" name:"AppId"`
	WorkspaceId string           `position:"Body" name:"WorkspaceId"`
}

// ListMcubeNebulaTasksResponse is the response struct for api ListMcubeNebulaTasks
type ListMcubeNebulaTasksResponse struct {
	*responses.BaseResponse
	ResultMessage             string                    `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode                string                    `json:"ResultCode" xml:"ResultCode"`
	RequestId                 string                    `json:"RequestId" xml:"RequestId"`
	ListMcubeNebulaTaskResult ListMcubeNebulaTaskResult `json:"ListMcubeNebulaTaskResult" xml:"ListMcubeNebulaTaskResult"`
}

// CreateListMcubeNebulaTasksRequest creates a request to invoke ListMcubeNebulaTasks API
func CreateListMcubeNebulaTasksRequest() (request *ListMcubeNebulaTasksRequest) {
	request = &ListMcubeNebulaTasksRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "ListMcubeNebulaTasks", "", "")
	request.Method = requests.POST
	return
}

// CreateListMcubeNebulaTasksResponse creates a response to parse from ListMcubeNebulaTasks response
func CreateListMcubeNebulaTasksResponse() (response *ListMcubeNebulaTasksResponse) {
	response = &ListMcubeNebulaTasksResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
