package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListMcdpAim invokes the mpaas.ListMcdpAim API synchronously
func (client *Client) ListMcdpAim(request *ListMcdpAimRequest) (response *ListMcdpAimResponse, err error) {
	response = CreateListMcdpAimResponse()
	err = client.DoAction(request, response)
	return
}

// ListMcdpAimWithChan invokes the mpaas.ListMcdpAim API asynchronously
func (client *Client) ListMcdpAimWithChan(request *ListMcdpAimRequest) (<-chan *ListMcdpAimResponse, <-chan error) {
	responseChan := make(chan *ListMcdpAimResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListMcdpAim(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListMcdpAimWithCallback invokes the mpaas.ListMcdpAim API asynchronously
func (client *Client) ListMcdpAimWithCallback(request *ListMcdpAimRequest, callback func(response *ListMcdpAimResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListMcdpAimResponse
		var err error
		defer close(result)
		response, err = client.ListMcdpAim(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListMcdpAimRequest is the request struct for api ListMcdpAim
type ListMcdpAimRequest struct {
	*requests.RpcRequest
	Type        string           `position:"Body" name:"Type"`
	PageSize    requests.Integer `position:"Body" name:"PageSize"`
	TenantId    string           `position:"Body" name:"TenantId"`
	Keyword     string           `position:"Body" name:"Keyword"`
	Sort        string           `position:"Body" name:"Sort"`
	EmptyTag    string           `position:"Body" name:"EmptyTag"`
	PageNo      requests.Integer `position:"Body" name:"PageNo"`
	AppId       string           `position:"Body" name:"AppId"`
	Name        string           `position:"Body" name:"Name"`
	SortField   string           `position:"Body" name:"SortField"`
	WorkspaceId string           `position:"Body" name:"WorkspaceId"`
}

// ListMcdpAimResponse is the response struct for api ListMcdpAim
type ListMcdpAimResponse struct {
	*responses.BaseResponse
	ResultMessage string                     `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode    string                     `json:"ResultCode" xml:"ResultCode"`
	RequestId     string                     `json:"RequestId" xml:"RequestId"`
	ResultContent ResultContentInListMcdpAim `json:"ResultContent" xml:"ResultContent"`
}

// CreateListMcdpAimRequest creates a request to invoke ListMcdpAim API
func CreateListMcdpAimRequest() (request *ListMcdpAimRequest) {
	request = &ListMcdpAimRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "ListMcdpAim", "", "")
	request.Method = requests.POST
	return
}

// CreateListMcdpAimResponse creates a response to parse from ListMcdpAim response
func CreateListMcdpAimResponse() (response *ListMcdpAimResponse) {
	response = &ListMcdpAimResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
