package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteMsacAppInstanceById invokes the mpaas.DeleteMsacAppInstanceById API synchronously
func (client *Client) DeleteMsacAppInstanceById(request *DeleteMsacAppInstanceByIdRequest) (response *DeleteMsacAppInstanceByIdResponse, err error) {
	response = CreateDeleteMsacAppInstanceByIdResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteMsacAppInstanceByIdWithChan invokes the mpaas.DeleteMsacAppInstanceById API asynchronously
func (client *Client) DeleteMsacAppInstanceByIdWithChan(request *DeleteMsacAppInstanceByIdRequest) (<-chan *DeleteMsacAppInstanceByIdResponse, <-chan error) {
	responseChan := make(chan *DeleteMsacAppInstanceByIdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteMsacAppInstanceById(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteMsacAppInstanceByIdWithCallback invokes the mpaas.DeleteMsacAppInstanceById API asynchronously
func (client *Client) DeleteMsacAppInstanceByIdWithCallback(request *DeleteMsacAppInstanceByIdRequest, callback func(response *DeleteMsacAppInstanceByIdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteMsacAppInstanceByIdResponse
		var err error
		defer close(result)
		response, err = client.DeleteMsacAppInstanceById(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteMsacAppInstanceByIdRequest is the request struct for api DeleteMsacAppInstanceById
type DeleteMsacAppInstanceByIdRequest struct {
	*requests.RpcRequest
	TenantId                                    string `position:"Body" name:"TenantId"`
	MpaasMappcenterMsacDeleteAppInstanceJsonStr string `position:"Body" name:"MpaasMappcenterMsacDeleteAppInstanceJsonStr"`
	AppId                                       string `position:"Body" name:"AppId"`
	WorkspaceId                                 string `position:"Body" name:"WorkspaceId"`
}

// DeleteMsacAppInstanceByIdResponse is the response struct for api DeleteMsacAppInstanceById
type DeleteMsacAppInstanceByIdResponse struct {
	*responses.BaseResponse
	ResultMessage string                                   `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode    string                                   `json:"ResultCode" xml:"ResultCode"`
	RequestId     string                                   `json:"RequestId" xml:"RequestId"`
	ResultContent ResultContentInDeleteMsacAppInstanceById `json:"ResultContent" xml:"ResultContent"`
}

// CreateDeleteMsacAppInstanceByIdRequest creates a request to invoke DeleteMsacAppInstanceById API
func CreateDeleteMsacAppInstanceByIdRequest() (request *DeleteMsacAppInstanceByIdRequest) {
	request = &DeleteMsacAppInstanceByIdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "DeleteMsacAppInstanceById", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteMsacAppInstanceByIdResponse creates a response to parse from DeleteMsacAppInstanceById response
func CreateDeleteMsacAppInstanceByIdResponse() (response *DeleteMsacAppInstanceByIdResponse) {
	response = &DeleteMsacAppInstanceByIdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
