package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateMcubeVhost invokes the mpaas.CreateMcubeVhost API synchronously
func (client *Client) CreateMcubeVhost(request *CreateMcubeVhostRequest) (response *CreateMcubeVhostResponse, err error) {
	response = CreateCreateMcubeVhostResponse()
	err = client.DoAction(request, response)
	return
}

// CreateMcubeVhostWithChan invokes the mpaas.CreateMcubeVhost API asynchronously
func (client *Client) CreateMcubeVhostWithChan(request *CreateMcubeVhostRequest) (<-chan *CreateMcubeVhostResponse, <-chan error) {
	responseChan := make(chan *CreateMcubeVhostResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateMcubeVhost(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateMcubeVhostWithCallback invokes the mpaas.CreateMcubeVhost API asynchronously
func (client *Client) CreateMcubeVhostWithCallback(request *CreateMcubeVhostRequest, callback func(response *CreateMcubeVhostResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateMcubeVhostResponse
		var err error
		defer close(result)
		response, err = client.CreateMcubeVhost(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateMcubeVhostRequest is the request struct for api CreateMcubeVhost
type CreateMcubeVhostRequest struct {
	*requests.RpcRequest
	TenantId    string `position:"Body" name:"TenantId"`
	Vhost       string `position:"Body" name:"Vhost"`
	AppId       string `position:"Body" name:"AppId"`
	WorkspaceId string `position:"Body" name:"WorkspaceId"`
}

// CreateMcubeVhostResponse is the response struct for api CreateMcubeVhost
type CreateMcubeVhostResponse struct {
	*responses.BaseResponse
	ResultMessage     string            `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode        string            `json:"ResultCode" xml:"ResultCode"`
	RequestId         string            `json:"RequestId" xml:"RequestId"`
	CreateVhostResult CreateVhostResult `json:"CreateVhostResult" xml:"CreateVhostResult"`
}

// CreateCreateMcubeVhostRequest creates a request to invoke CreateMcubeVhost API
func CreateCreateMcubeVhostRequest() (request *CreateMcubeVhostRequest) {
	request = &CreateMcubeVhostRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "CreateMcubeVhost", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateMcubeVhostResponse creates a response to parse from CreateMcubeVhost response
func CreateCreateMcubeVhostResponse() (response *CreateMcubeVhostResponse) {
	response = &CreateMcubeVhostResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
