package market

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PauseProject invokes the market.PauseProject API synchronously
func (client *Client) PauseProject(request *PauseProjectRequest) (response *PauseProjectResponse, err error) {
	response = CreatePauseProjectResponse()
	err = client.DoAction(request, response)
	return
}

// PauseProjectWithChan invokes the market.PauseProject API asynchronously
func (client *Client) PauseProjectWithChan(request *PauseProjectRequest) (<-chan *PauseProjectResponse, <-chan error) {
	responseChan := make(chan *PauseProjectResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PauseProject(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PauseProjectWithCallback invokes the market.PauseProject API asynchronously
func (client *Client) PauseProjectWithCallback(request *PauseProjectRequest, callback func(response *PauseProjectResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PauseProjectResponse
		var err error
		defer close(result)
		response, err = client.PauseProject(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PauseProjectRequest is the request struct for api PauseProject
type PauseProjectRequest struct {
	*requests.RpcRequest
	Remark     string           `position:"Query" name:"Remark"`
	InstanceId string           `position:"Query" name:"InstanceId"`
	NodeId     requests.Integer `position:"Query" name:"NodeId"`
}

// PauseProjectResponse is the response struct for api PauseProject
type PauseProjectResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    bool   `json:"Result" xml:"Result"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreatePauseProjectRequest creates a request to invoke PauseProject API
func CreatePauseProjectRequest() (request *PauseProjectRequest) {
	request = &PauseProjectRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Market", "2015-11-01", "PauseProject", "yunmarket", "openAPI")
	request.Method = requests.POST
	return
}

// CreatePauseProjectResponse creates a response to parse from PauseProject response
func CreatePauseProjectResponse() (response *PauseProjectResponse) {
	response = &PauseProjectResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
