package lto

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeMemberStatInfo invokes the lto.DescribeMemberStatInfo API synchronously
func (client *Client) DescribeMemberStatInfo(request *DescribeMemberStatInfoRequest) (response *DescribeMemberStatInfoResponse, err error) {
	response = CreateDescribeMemberStatInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeMemberStatInfoWithChan invokes the lto.DescribeMemberStatInfo API asynchronously
func (client *Client) DescribeMemberStatInfoWithChan(request *DescribeMemberStatInfoRequest) (<-chan *DescribeMemberStatInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeMemberStatInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeMemberStatInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeMemberStatInfoWithCallback invokes the lto.DescribeMemberStatInfo API asynchronously
func (client *Client) DescribeMemberStatInfoWithCallback(request *DescribeMemberStatInfoRequest, callback func(response *DescribeMemberStatInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeMemberStatInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeMemberStatInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeMemberStatInfoRequest is the request struct for api DescribeMemberStatInfo
type DescribeMemberStatInfoRequest struct {
	*requests.RpcRequest
	BizChainId string `position:"Query" name:"BizChainId"`
}

// DescribeMemberStatInfoResponse is the response struct for api DescribeMemberStatInfo
type DescribeMemberStatInfoResponse struct {
	*responses.BaseResponse
	Code           string           `json:"Code" xml:"Code"`
	HttpStatusCode int              `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string           `json:"Message" xml:"Message"`
	RequestId      string           `json:"RequestId" xml:"RequestId"`
	Success        bool             `json:"Success" xml:"Success"`
	Data           []MemberStatInfo `json:"Data" xml:"Data"`
}

// CreateDescribeMemberStatInfoRequest creates a request to invoke DescribeMemberStatInfo API
func CreateDescribeMemberStatInfoRequest() (request *DescribeMemberStatInfoRequest) {
	request = &DescribeMemberStatInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("lto", "2021-07-07", "DescribeMemberStatInfo", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeMemberStatInfoResponse creates a response to parse from DescribeMemberStatInfo response
func CreateDescribeMemberStatInfoResponse() (response *DescribeMemberStatInfoResponse) {
	response = &DescribeMemberStatInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
