package ltl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ApplyDataModelConfigInfo invokes the ltl.ApplyDataModelConfigInfo API synchronously
func (client *Client) ApplyDataModelConfigInfo(request *ApplyDataModelConfigInfoRequest) (response *ApplyDataModelConfigInfoResponse, err error) {
	response = CreateApplyDataModelConfigInfoResponse()
	err = client.DoAction(request, response)
	return
}

// ApplyDataModelConfigInfoWithChan invokes the ltl.ApplyDataModelConfigInfo API asynchronously
func (client *Client) ApplyDataModelConfigInfoWithChan(request *ApplyDataModelConfigInfoRequest) (<-chan *ApplyDataModelConfigInfoResponse, <-chan error) {
	responseChan := make(chan *ApplyDataModelConfigInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ApplyDataModelConfigInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ApplyDataModelConfigInfoWithCallback invokes the ltl.ApplyDataModelConfigInfo API asynchronously
func (client *Client) ApplyDataModelConfigInfoWithCallback(request *ApplyDataModelConfigInfoRequest, callback func(response *ApplyDataModelConfigInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ApplyDataModelConfigInfoResponse
		var err error
		defer close(result)
		response, err = client.ApplyDataModelConfigInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ApplyDataModelConfigInfoRequest is the request struct for api ApplyDataModelConfigInfo
type ApplyDataModelConfigInfoRequest struct {
	*requests.RpcRequest
	Configuration string `position:"Query" name:"Configuration"`
	ApiVersion    string `position:"Query" name:"ApiVersion"`
	ProductKey    string `position:"Query" name:"ProductKey"`
	DataModelCode string `position:"Query" name:"DataModelCode"`
}

// ApplyDataModelConfigInfoResponse is the response struct for api ApplyDataModelConfigInfo
type ApplyDataModelConfigInfoResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateApplyDataModelConfigInfoRequest creates a request to invoke ApplyDataModelConfigInfo API
func CreateApplyDataModelConfigInfoRequest() (request *ApplyDataModelConfigInfoRequest) {
	request = &ApplyDataModelConfigInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ltl", "2019-05-10", "ApplyDataModelConfigInfo", "", "")
	request.Method = requests.POST
	return
}

// CreateApplyDataModelConfigInfoResponse creates a response to parse from ApplyDataModelConfigInfo response
func CreateApplyDataModelConfigInfoResponse() (response *ApplyDataModelConfigInfoResponse) {
	response = &ApplyDataModelConfigInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
