package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateLiveMPUTask invokes the live.UpdateLiveMPUTask API synchronously
func (client *Client) UpdateLiveMPUTask(request *UpdateLiveMPUTaskRequest) (response *UpdateLiveMPUTaskResponse, err error) {
	response = CreateUpdateLiveMPUTaskResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateLiveMPUTaskWithChan invokes the live.UpdateLiveMPUTask API asynchronously
func (client *Client) UpdateLiveMPUTaskWithChan(request *UpdateLiveMPUTaskRequest) (<-chan *UpdateLiveMPUTaskResponse, <-chan error) {
	responseChan := make(chan *UpdateLiveMPUTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateLiveMPUTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateLiveMPUTaskWithCallback invokes the live.UpdateLiveMPUTask API asynchronously
func (client *Client) UpdateLiveMPUTaskWithCallback(request *UpdateLiveMPUTaskRequest, callback func(response *UpdateLiveMPUTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateLiveMPUTaskResponse
		var err error
		defer close(result)
		response, err = client.UpdateLiveMPUTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateLiveMPUTaskRequest is the request struct for api UpdateLiveMPUTask
type UpdateLiveMPUTaskRequest struct {
	*requests.RpcRequest
	MultiStreamURL  *[]UpdateLiveMPUTaskMultiStreamURL `position:"Query" name:"MultiStreamURL"  type:"Json"`
	SingleSubParams UpdateLiveMPUTaskSingleSubParams   `position:"Query" name:"SingleSubParams"  type:"Struct"`
	SeiParams       UpdateLiveMPUTaskSeiParams         `position:"Query" name:"SeiParams"  type:"Struct"`
	TranscodeParams UpdateLiveMPUTaskTranscodeParams   `position:"Query" name:"TranscodeParams"  type:"Struct"`
	AppId           string                             `position:"Query" name:"AppId"`
	MixMode         string                             `position:"Query" name:"MixMode"`
	ChannelId       string                             `position:"Query" name:"ChannelId"`
	TaskId          string                             `position:"Query" name:"TaskId"`
	StreamURL       string                             `position:"Query" name:"StreamURL"`
}

// UpdateLiveMPUTaskMultiStreamURL is a repeated param struct in UpdateLiveMPUTaskRequest
type UpdateLiveMPUTaskMultiStreamURL struct {
	IsAliCdn string `name:"IsAliCdn"`
	URL      string `name:"URL"`
}

// UpdateLiveMPUTaskSingleSubParams is a repeated param struct in UpdateLiveMPUTaskRequest
type UpdateLiveMPUTaskSingleSubParams struct {
	MixAudioUserIds *[]string `name:"MixAudioUserIds" type:"Repeated"`
	StreamType      string    `name:"StreamType"`
	SourceType      string    `name:"SourceType"`
	UserId          string    `name:"UserId"`
}

// UpdateLiveMPUTaskSeiParams is a repeated param struct in UpdateLiveMPUTaskRequest
type UpdateLiveMPUTaskSeiParams struct {
	LayoutVolume UpdateLiveMPUTaskSeiParamsLayoutVolume `name:"LayoutVolume" type:"Struct"`
	PassThrough  UpdateLiveMPUTaskSeiParamsPassThrough  `name:"PassThrough" type:"Struct"`
}

// UpdateLiveMPUTaskTranscodeParams is a repeated param struct in UpdateLiveMPUTaskRequest
type UpdateLiveMPUTaskTranscodeParams struct {
	Layout       UpdateLiveMPUTaskTranscodeParamsLayout           `name:"Layout" type:"Struct"`
	Background   UpdateLiveMPUTaskTranscodeParamsBackground       `name:"Background" type:"Struct"`
	UserInfos    *[]UpdateLiveMPUTaskTranscodeParamsUserInfosItem `name:"UserInfos" type:"Repeated"`
	EncodeParams UpdateLiveMPUTaskTranscodeParamsEncodeParams     `name:"EncodeParams" type:"Struct"`
}

// UpdateLiveMPUTaskSeiParamsLayoutVolume is a repeated param struct in UpdateLiveMPUTaskRequest
type UpdateLiveMPUTaskSeiParamsLayoutVolume struct {
	FollowIdr string `name:"FollowIdr"`
	Interval  string `name:"Interval"`
}

// UpdateLiveMPUTaskSeiParamsPassThrough is a repeated param struct in UpdateLiveMPUTaskRequest
type UpdateLiveMPUTaskSeiParamsPassThrough struct {
	FollowIdr         string `name:"FollowIdr"`
	PayloadContentKey string `name:"PayloadContentKey"`
	PayloadContent    string `name:"PayloadContent"`
	Interval          string `name:"Interval"`
}

// UpdateLiveMPUTaskTranscodeParamsLayout is a repeated param struct in UpdateLiveMPUTaskRequest
type UpdateLiveMPUTaskTranscodeParamsLayout struct {
	UserPanes    *[]UpdateLiveMPUTaskTranscodeParamsLayoutUserPanesItem `name:"UserPanes" type:"Repeated"`
	LayoutMode   string                                                 `name:"LayoutMode"`
	MaxVideoUser UpdateLiveMPUTaskTranscodeParamsLayoutMaxVideoUser     `name:"MaxVideoUser" type:"Struct"`
}

// UpdateLiveMPUTaskTranscodeParamsBackground is a repeated param struct in UpdateLiveMPUTaskRequest
type UpdateLiveMPUTaskTranscodeParamsBackground struct {
	RenderMode string `name:"RenderMode"`
	URL        string `name:"URL"`
}

// UpdateLiveMPUTaskTranscodeParamsUserInfosItem is a repeated param struct in UpdateLiveMPUTaskRequest
type UpdateLiveMPUTaskTranscodeParamsUserInfosItem struct {
	StreamType string `name:"StreamType"`
	SourceType string `name:"SourceType"`
	UserId     string `name:"UserId"`
	ChannelId  string `name:"ChannelId"`
}

// UpdateLiveMPUTaskTranscodeParamsEncodeParams is a repeated param struct in UpdateLiveMPUTaskRequest
type UpdateLiveMPUTaskTranscodeParamsEncodeParams struct {
	AudioOnly       string `name:"AudioOnly"`
	VideoWidth      string `name:"VideoWidth"`
	AudioBitrate    string `name:"AudioBitrate"`
	EnhancedParam   string `name:"EnhancedParam"`
	VideoFramerate  string `name:"VideoFramerate"`
	VideoHeight     string `name:"VideoHeight"`
	AudioSampleRate string `name:"AudioSampleRate"`
	VideoBitrate    string `name:"VideoBitrate"`
	VideoCodec      string `name:"VideoCodec"`
	AudioChannels   string `name:"AudioChannels"`
	VideoGop        string `name:"VideoGop"`
}

// UpdateLiveMPUTaskTranscodeParamsLayoutUserPanesItem is a repeated param struct in UpdateLiveMPUTaskRequest
type UpdateLiveMPUTaskTranscodeParamsLayoutUserPanesItem struct {
	BackgroundImageUrl string                                                      `name:"BackgroundImageUrl"`
	ZOrder             string                                                      `name:"ZOrder"`
	Width              string                                                      `name:"Width"`
	X                  string                                                      `name:"X"`
	Y                  string                                                      `name:"Y"`
	UserInfo           UpdateLiveMPUTaskTranscodeParamsLayoutUserPanesItemUserInfo `name:"UserInfo" type:"Struct"`
	RenderMode         string                                                      `name:"RenderMode"`
	Height             string                                                      `name:"Height"`
}

// UpdateLiveMPUTaskTranscodeParamsLayoutMaxVideoUser is a repeated param struct in UpdateLiveMPUTaskRequest
type UpdateLiveMPUTaskTranscodeParamsLayoutMaxVideoUser struct {
	StreamType string `name:"StreamType"`
	SourceType string `name:"SourceType"`
	UserId     string `name:"UserId"`
	ChannelId  string `name:"ChannelId"`
}

// UpdateLiveMPUTaskTranscodeParamsLayoutUserPanesItemUserInfo is a repeated param struct in UpdateLiveMPUTaskRequest
type UpdateLiveMPUTaskTranscodeParamsLayoutUserPanesItemUserInfo struct {
	SourceType string `name:"SourceType"`
	UserId     string `name:"UserId"`
	ChannelId  string `name:"ChannelId"`
}

// UpdateLiveMPUTaskResponse is the response struct for api UpdateLiveMPUTask
type UpdateLiveMPUTaskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateLiveMPUTaskRequest creates a request to invoke UpdateLiveMPUTask API
func CreateUpdateLiveMPUTaskRequest() (request *UpdateLiveMPUTaskRequest) {
	request = &UpdateLiveMPUTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "UpdateLiveMPUTask", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateLiveMPUTaskResponse creates a response to parse from UpdateLiveMPUTask response
func CreateUpdateLiveMPUTaskResponse() (response *UpdateLiveMPUTaskResponse) {
	response = &UpdateLiveMPUTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
