package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryRtcAsrTasks invokes the live.QueryRtcAsrTasks API synchronously
func (client *Client) QueryRtcAsrTasks(request *QueryRtcAsrTasksRequest) (response *QueryRtcAsrTasksResponse, err error) {
	response = CreateQueryRtcAsrTasksResponse()
	err = client.DoAction(request, response)
	return
}

// QueryRtcAsrTasksWithChan invokes the live.QueryRtcAsrTasks API asynchronously
func (client *Client) QueryRtcAsrTasksWithChan(request *QueryRtcAsrTasksRequest) (<-chan *QueryRtcAsrTasksResponse, <-chan error) {
	responseChan := make(chan *QueryRtcAsrTasksResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryRtcAsrTasks(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryRtcAsrTasksWithCallback invokes the live.QueryRtcAsrTasks API asynchronously
func (client *Client) QueryRtcAsrTasksWithCallback(request *QueryRtcAsrTasksRequest, callback func(response *QueryRtcAsrTasksResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryRtcAsrTasksResponse
		var err error
		defer close(result)
		response, err = client.QueryRtcAsrTasks(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryRtcAsrTasksRequest is the request struct for api QueryRtcAsrTasks
type QueryRtcAsrTasksRequest struct {
	*requests.RpcRequest
	TaskId  string           `position:"Query" name:"TaskId"`
	OwnerId requests.Integer `position:"Query" name:"OwnerId"`
}

// QueryRtcAsrTasksResponse is the response struct for api QueryRtcAsrTasks
type QueryRtcAsrTasksResponse struct {
	*responses.BaseResponse
}

// CreateQueryRtcAsrTasksRequest creates a request to invoke QueryRtcAsrTasks API
func CreateQueryRtcAsrTasksRequest() (request *QueryRtcAsrTasksRequest) {
	request = &QueryRtcAsrTasksRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "QueryRtcAsrTasks", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryRtcAsrTasksResponse creates a response to parse from QueryRtcAsrTasks response
func CreateQueryRtcAsrTasksResponse() (response *QueryRtcAsrTasksResponse) {
	response = &QueryRtcAsrTasksResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
