package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListLiveMessageGroups invokes the live.ListLiveMessageGroups API synchronously
func (client *Client) ListLiveMessageGroups(request *ListLiveMessageGroupsRequest) (response *ListLiveMessageGroupsResponse, err error) {
	response = CreateListLiveMessageGroupsResponse()
	err = client.DoAction(request, response)
	return
}

// ListLiveMessageGroupsWithChan invokes the live.ListLiveMessageGroups API asynchronously
func (client *Client) ListLiveMessageGroupsWithChan(request *ListLiveMessageGroupsRequest) (<-chan *ListLiveMessageGroupsResponse, <-chan error) {
	responseChan := make(chan *ListLiveMessageGroupsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListLiveMessageGroups(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListLiveMessageGroupsWithCallback invokes the live.ListLiveMessageGroups API asynchronously
func (client *Client) ListLiveMessageGroupsWithCallback(request *ListLiveMessageGroupsRequest, callback func(response *ListLiveMessageGroupsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListLiveMessageGroupsResponse
		var err error
		defer close(result)
		response, err = client.ListLiveMessageGroups(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListLiveMessageGroupsRequest is the request struct for api ListLiveMessageGroups
type ListLiveMessageGroupsRequest struct {
	*requests.RpcRequest
	SortType      requests.Integer `position:"Query" name:"SortType"`
	GroupStatus   requests.Integer `position:"Query" name:"GroupStatus"`
	NextPageToken requests.Integer `position:"Query" name:"NextPageToken"`
	DataCenter    string           `position:"Query" name:"DataCenter"`
	AppId         string           `position:"Query" name:"AppId"`
}

// ListLiveMessageGroupsResponse is the response struct for api ListLiveMessageGroups
type ListLiveMessageGroupsResponse struct {
	*responses.BaseResponse
	RequestId     string   `json:"RequestId" xml:"RequestId"`
	Hasmore       bool     `json:"Hasmore" xml:"Hasmore"`
	NextpageToken string   `json:"NextpageToken" xml:"NextpageToken"`
	GroupList     []Groups `json:"GroupList" xml:"GroupList"`
}

// CreateListLiveMessageGroupsRequest creates a request to invoke ListLiveMessageGroups API
func CreateListLiveMessageGroupsRequest() (request *ListLiveMessageGroupsRequest) {
	request = &ListLiveMessageGroupsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "ListLiveMessageGroups", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListLiveMessageGroupsResponse creates a response to parse from ListLiveMessageGroups response
func CreateListLiveMessageGroupsResponse() (response *ListLiveMessageGroupsResponse) {
	response = &ListLiveMessageGroupsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
