package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLiveRecordNotifyRecords invokes the live.DescribeLiveRecordNotifyRecords API synchronously
func (client *Client) DescribeLiveRecordNotifyRecords(request *DescribeLiveRecordNotifyRecordsRequest) (response *DescribeLiveRecordNotifyRecordsResponse, err error) {
	response = CreateDescribeLiveRecordNotifyRecordsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLiveRecordNotifyRecordsWithChan invokes the live.DescribeLiveRecordNotifyRecords API asynchronously
func (client *Client) DescribeLiveRecordNotifyRecordsWithChan(request *DescribeLiveRecordNotifyRecordsRequest) (<-chan *DescribeLiveRecordNotifyRecordsResponse, <-chan error) {
	responseChan := make(chan *DescribeLiveRecordNotifyRecordsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLiveRecordNotifyRecords(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLiveRecordNotifyRecordsWithCallback invokes the live.DescribeLiveRecordNotifyRecords API asynchronously
func (client *Client) DescribeLiveRecordNotifyRecordsWithCallback(request *DescribeLiveRecordNotifyRecordsRequest, callback func(response *DescribeLiveRecordNotifyRecordsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLiveRecordNotifyRecordsResponse
		var err error
		defer close(result)
		response, err = client.DescribeLiveRecordNotifyRecords(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLiveRecordNotifyRecordsRequest is the request struct for api DescribeLiveRecordNotifyRecords
type DescribeLiveRecordNotifyRecordsRequest struct {
	*requests.RpcRequest
	StartTime  string           `position:"Query" name:"StartTime"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	AppName    string           `position:"Query" name:"AppName"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	StreamName string           `position:"Query" name:"StreamName"`
	DomainName string           `position:"Query" name:"DomainName"`
	EndTime    string           `position:"Query" name:"EndTime"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
	Status     string           `position:"Query" name:"Status"`
}

// DescribeLiveRecordNotifyRecordsResponse is the response struct for api DescribeLiveRecordNotifyRecords
type DescribeLiveRecordNotifyRecordsResponse struct {
	*responses.BaseResponse
	Code         int        `json:"Code" xml:"Code"`
	Msg          string     `json:"Msg" xml:"Msg"`
	PageNum      int        `json:"PageNum" xml:"PageNum"`
	PageSize     int        `json:"PageSize" xml:"PageSize"`
	RequestId    string     `json:"RequestId" xml:"RequestId"`
	TotalNum     int        `json:"TotalNum" xml:"TotalNum"`
	TotalPage    int        `json:"TotalPage" xml:"TotalPage"`
	CallbackList []Callback `json:"CallbackList" xml:"CallbackList"`
}

// CreateDescribeLiveRecordNotifyRecordsRequest creates a request to invoke DescribeLiveRecordNotifyRecords API
func CreateDescribeLiveRecordNotifyRecordsRequest() (request *DescribeLiveRecordNotifyRecordsRequest) {
	request = &DescribeLiveRecordNotifyRecordsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DescribeLiveRecordNotifyRecords", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeLiveRecordNotifyRecordsResponse creates a response to parse from DescribeLiveRecordNotifyRecords response
func CreateDescribeLiveRecordNotifyRecordsResponse() (response *DescribeLiveRecordNotifyRecordsResponse) {
	response = &DescribeLiveRecordNotifyRecordsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
