package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLivePushProxyLog invokes the live.DescribeLivePushProxyLog API synchronously
func (client *Client) DescribeLivePushProxyLog(request *DescribeLivePushProxyLogRequest) (response *DescribeLivePushProxyLogResponse, err error) {
	response = CreateDescribeLivePushProxyLogResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLivePushProxyLogWithChan invokes the live.DescribeLivePushProxyLog API asynchronously
func (client *Client) DescribeLivePushProxyLogWithChan(request *DescribeLivePushProxyLogRequest) (<-chan *DescribeLivePushProxyLogResponse, <-chan error) {
	responseChan := make(chan *DescribeLivePushProxyLogResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLivePushProxyLog(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLivePushProxyLogWithCallback invokes the live.DescribeLivePushProxyLog API asynchronously
func (client *Client) DescribeLivePushProxyLogWithCallback(request *DescribeLivePushProxyLogRequest, callback func(response *DescribeLivePushProxyLogResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLivePushProxyLogResponse
		var err error
		defer close(result)
		response, err = client.DescribeLivePushProxyLog(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLivePushProxyLogRequest is the request struct for api DescribeLivePushProxyLog
type DescribeLivePushProxyLogRequest struct {
	*requests.RpcRequest
	StartTime  string           `position:"Query" name:"StartTime"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	LogType    string           `position:"Query" name:"LogType"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	DomainName string           `position:"Query" name:"DomainName"`
	EndTime    string           `position:"Query" name:"EndTime"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeLivePushProxyLogResponse is the response struct for api DescribeLivePushProxyLog
type DescribeLivePushProxyLogResponse struct {
	*responses.BaseResponse
	DomainName       string                                     `json:"DomainName" xml:"DomainName"`
	RequestId        string                                     `json:"RequestId" xml:"RequestId"`
	DomainLogDetails DomainLogDetailsInDescribeLivePushProxyLog `json:"DomainLogDetails" xml:"DomainLogDetails"`
}

// CreateDescribeLivePushProxyLogRequest creates a request to invoke DescribeLivePushProxyLog API
func CreateDescribeLivePushProxyLogRequest() (request *DescribeLivePushProxyLogRequest) {
	request = &DescribeLivePushProxyLogRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DescribeLivePushProxyLog", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeLivePushProxyLogResponse creates a response to parse from DescribeLivePushProxyLog response
func CreateDescribeLivePushProxyLogResponse() (response *DescribeLivePushProxyLogResponse) {
	response = &DescribeLivePushProxyLogResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
