package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteLiveMessageGroupMessage invokes the live.DeleteLiveMessageGroupMessage API synchronously
func (client *Client) DeleteLiveMessageGroupMessage(request *DeleteLiveMessageGroupMessageRequest) (response *DeleteLiveMessageGroupMessageResponse, err error) {
	response = CreateDeleteLiveMessageGroupMessageResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteLiveMessageGroupMessageWithChan invokes the live.DeleteLiveMessageGroupMessage API asynchronously
func (client *Client) DeleteLiveMessageGroupMessageWithChan(request *DeleteLiveMessageGroupMessageRequest) (<-chan *DeleteLiveMessageGroupMessageResponse, <-chan error) {
	responseChan := make(chan *DeleteLiveMessageGroupMessageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteLiveMessageGroupMessage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteLiveMessageGroupMessageWithCallback invokes the live.DeleteLiveMessageGroupMessage API asynchronously
func (client *Client) DeleteLiveMessageGroupMessageWithCallback(request *DeleteLiveMessageGroupMessageRequest, callback func(response *DeleteLiveMessageGroupMessageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteLiveMessageGroupMessageResponse
		var err error
		defer close(result)
		response, err = client.DeleteLiveMessageGroupMessage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteLiveMessageGroupMessageRequest is the request struct for api DeleteLiveMessageGroupMessage
type DeleteLiveMessageGroupMessageRequest struct {
	*requests.RpcRequest
	GroupId     string `position:"Query" name:"GroupId"`
	MessageId   string `position:"Query" name:"MessageId"`
	DataCenter  string `position:"Query" name:"DataCenter"`
	AppId       string `position:"Query" name:"AppId"`
	DeleterId   string `position:"Query" name:"DeleterId"`
	DeleterInfo string `position:"Query" name:"DeleterInfo"`
}

// DeleteLiveMessageGroupMessageResponse is the response struct for api DeleteLiveMessageGroupMessage
type DeleteLiveMessageGroupMessageResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	GroupId   string `json:"GroupId" xml:"GroupId"`
	MessageId string `json:"MessageId" xml:"MessageId"`
}

// CreateDeleteLiveMessageGroupMessageRequest creates a request to invoke DeleteLiveMessageGroupMessage API
func CreateDeleteLiveMessageGroupMessageRequest() (request *DeleteLiveMessageGroupMessageRequest) {
	request = &DeleteLiveMessageGroupMessageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DeleteLiveMessageGroupMessage", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteLiveMessageGroupMessageResponse creates a response to parse from DeleteLiveMessageGroupMessage response
func CreateDeleteLiveMessageGroupMessageResponse() (response *DeleteLiveMessageGroupMessageResponse) {
	response = &DeleteLiveMessageGroupMessageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
