package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateMessageApp invokes the live.CreateMessageApp API synchronously
func (client *Client) CreateMessageApp(request *CreateMessageAppRequest) (response *CreateMessageAppResponse, err error) {
	response = CreateCreateMessageAppResponse()
	err = client.DoAction(request, response)
	return
}

// CreateMessageAppWithChan invokes the live.CreateMessageApp API asynchronously
func (client *Client) CreateMessageAppWithChan(request *CreateMessageAppRequest) (<-chan *CreateMessageAppResponse, <-chan error) {
	responseChan := make(chan *CreateMessageAppResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateMessageApp(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateMessageAppWithCallback invokes the live.CreateMessageApp API asynchronously
func (client *Client) CreateMessageAppWithCallback(request *CreateMessageAppRequest, callback func(response *CreateMessageAppResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateMessageAppResponse
		var err error
		defer close(result)
		response, err = client.CreateMessageApp(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateMessageAppRequest is the request struct for api CreateMessageApp
type CreateMessageAppRequest struct {
	*requests.RpcRequest
	Extension map[string]string `position:"Body" name:"Extension"  type:"Map"`
	AppConfig map[string]string `position:"Body" name:"AppConfig"  type:"Map"`
	AppName   string            `position:"Body" name:"AppName"`
}

// CreateMessageAppResponse is the response struct for api CreateMessageApp
type CreateMessageAppResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateCreateMessageAppRequest creates a request to invoke CreateMessageApp API
func CreateCreateMessageAppRequest() (request *CreateMessageAppRequest) {
	request = &CreateMessageAppRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "CreateMessageApp", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateMessageAppResponse creates a response to parse from CreateMessageApp response
func CreateCreateMessageAppResponse() (response *CreateMessageAppResponse) {
	response = &CreateMessageAppResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
