package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddLiveStreamWatermarkRule invokes the live.AddLiveStreamWatermarkRule API synchronously
func (client *Client) AddLiveStreamWatermarkRule(request *AddLiveStreamWatermarkRuleRequest) (response *AddLiveStreamWatermarkRuleResponse, err error) {
	response = CreateAddLiveStreamWatermarkRuleResponse()
	err = client.DoAction(request, response)
	return
}

// AddLiveStreamWatermarkRuleWithChan invokes the live.AddLiveStreamWatermarkRule API asynchronously
func (client *Client) AddLiveStreamWatermarkRuleWithChan(request *AddLiveStreamWatermarkRuleRequest) (<-chan *AddLiveStreamWatermarkRuleResponse, <-chan error) {
	responseChan := make(chan *AddLiveStreamWatermarkRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddLiveStreamWatermarkRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddLiveStreamWatermarkRuleWithCallback invokes the live.AddLiveStreamWatermarkRule API asynchronously
func (client *Client) AddLiveStreamWatermarkRuleWithCallback(request *AddLiveStreamWatermarkRuleRequest, callback func(response *AddLiveStreamWatermarkRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddLiveStreamWatermarkRuleResponse
		var err error
		defer close(result)
		response, err = client.AddLiveStreamWatermarkRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddLiveStreamWatermarkRuleRequest is the request struct for api AddLiveStreamWatermarkRule
type AddLiveStreamWatermarkRuleRequest struct {
	*requests.RpcRequest
	Description string           `position:"Query" name:"Description"`
	Stream      string           `position:"Query" name:"Stream"`
	App         string           `position:"Query" name:"App"`
	OwnerId     requests.Integer `position:"Query" name:"OwnerId"`
	TemplateId  string           `position:"Query" name:"TemplateId"`
	Domain      string           `position:"Query" name:"Domain"`
	Name        string           `position:"Query" name:"Name"`
}

// AddLiveStreamWatermarkRuleResponse is the response struct for api AddLiveStreamWatermarkRule
type AddLiveStreamWatermarkRuleResponse struct {
	*responses.BaseResponse
	RuleId    string `json:"RuleId" xml:"RuleId"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAddLiveStreamWatermarkRuleRequest creates a request to invoke AddLiveStreamWatermarkRule API
func CreateAddLiveStreamWatermarkRuleRequest() (request *AddLiveStreamWatermarkRuleRequest) {
	request = &AddLiveStreamWatermarkRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "AddLiveStreamWatermarkRule", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddLiveStreamWatermarkRuleResponse creates a response to parse from AddLiveStreamWatermarkRule response
func CreateAddLiveStreamWatermarkRuleResponse() (response *AddLiveStreamWatermarkRuleResponse) {
	response = &AddLiveStreamWatermarkRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
