package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddLiveAISubtitle invokes the live.AddLiveAISubtitle API synchronously
func (client *Client) AddLiveAISubtitle(request *AddLiveAISubtitleRequest) (response *AddLiveAISubtitleResponse, err error) {
	response = CreateAddLiveAISubtitleResponse()
	err = client.DoAction(request, response)
	return
}

// AddLiveAISubtitleWithChan invokes the live.AddLiveAISubtitle API asynchronously
func (client *Client) AddLiveAISubtitleWithChan(request *AddLiveAISubtitleRequest) (<-chan *AddLiveAISubtitleResponse, <-chan error) {
	responseChan := make(chan *AddLiveAISubtitleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddLiveAISubtitle(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddLiveAISubtitleWithCallback invokes the live.AddLiveAISubtitle API asynchronously
func (client *Client) AddLiveAISubtitleWithCallback(request *AddLiveAISubtitleRequest, callback func(response *AddLiveAISubtitleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddLiveAISubtitleResponse
		var err error
		defer close(result)
		response, err = client.AddLiveAISubtitle(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddLiveAISubtitleRequest is the request struct for api AddLiveAISubtitle
type AddLiveAISubtitleRequest struct {
	*requests.RpcRequest
	SrcLanguage           string           `position:"Query" name:"SrcLanguage"`
	Description           string           `position:"Query" name:"Description"`
	FontName              string           `position:"Query" name:"FontName"`
	SubtitleName          string           `position:"Query" name:"SubtitleName"`
	FontSizeNormalized    requests.Float   `position:"Query" name:"FontSizeNormalized"`
	FontColor             string           `position:"Query" name:"FontColor"`
	ShowSourceLan         requests.Boolean `position:"Query" name:"ShowSourceLan"`
	PositionNormalized    *[]string        `position:"Query" name:"PositionNormalized"  type:"Json"`
	BorderWidthNormalized requests.Float   `position:"Query" name:"BorderWidthNormalized"`
	MaxLines              requests.Integer `position:"Query" name:"MaxLines"`
	Height                string           `position:"Query" name:"Height"`
	WordPerLine           requests.Integer `position:"Query" name:"WordPerLine"`
	OwnerId               requests.Integer `position:"Query" name:"OwnerId"`
	BgWidthNormalized     requests.Float   `position:"Query" name:"BgWidthNormalized"`
	BgColor               string           `position:"Query" name:"BgColor"`
	DstLanguage           string           `position:"Query" name:"DstLanguage"`
	Width                 string           `position:"Query" name:"Width"`
	CopyFrom              string           `position:"Query" name:"CopyFrom"`
}

// AddLiveAISubtitleResponse is the response struct for api AddLiveAISubtitle
type AddLiveAISubtitleResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	SubtitleId string `json:"SubtitleId" xml:"SubtitleId"`
}

// CreateAddLiveAISubtitleRequest creates a request to invoke AddLiveAISubtitle API
func CreateAddLiveAISubtitleRequest() (request *AddLiveAISubtitleRequest) {
	request = &AddLiveAISubtitleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "AddLiveAISubtitle", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddLiveAISubtitleResponse creates a response to parse from AddLiveAISubtitle response
func CreateAddLiveAISubtitleResponse() (response *AddLiveAISubtitleResponse) {
	response = &AddLiveAISubtitleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
