package linkvisual

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryFaceAllUserGroupAndDeviceGroupRelation invokes the linkvisual.QueryFaceAllUserGroupAndDeviceGroupRelation API synchronously
func (client *Client) QueryFaceAllUserGroupAndDeviceGroupRelation(request *QueryFaceAllUserGroupAndDeviceGroupRelationRequest) (response *QueryFaceAllUserGroupAndDeviceGroupRelationResponse, err error) {
	response = CreateQueryFaceAllUserGroupAndDeviceGroupRelationResponse()
	err = client.DoAction(request, response)
	return
}

// QueryFaceAllUserGroupAndDeviceGroupRelationWithChan invokes the linkvisual.QueryFaceAllUserGroupAndDeviceGroupRelation API asynchronously
func (client *Client) QueryFaceAllUserGroupAndDeviceGroupRelationWithChan(request *QueryFaceAllUserGroupAndDeviceGroupRelationRequest) (<-chan *QueryFaceAllUserGroupAndDeviceGroupRelationResponse, <-chan error) {
	responseChan := make(chan *QueryFaceAllUserGroupAndDeviceGroupRelationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryFaceAllUserGroupAndDeviceGroupRelation(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryFaceAllUserGroupAndDeviceGroupRelationWithCallback invokes the linkvisual.QueryFaceAllUserGroupAndDeviceGroupRelation API asynchronously
func (client *Client) QueryFaceAllUserGroupAndDeviceGroupRelationWithCallback(request *QueryFaceAllUserGroupAndDeviceGroupRelationRequest, callback func(response *QueryFaceAllUserGroupAndDeviceGroupRelationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryFaceAllUserGroupAndDeviceGroupRelationResponse
		var err error
		defer close(result)
		response, err = client.QueryFaceAllUserGroupAndDeviceGroupRelation(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryFaceAllUserGroupAndDeviceGroupRelationRequest is the request struct for api QueryFaceAllUserGroupAndDeviceGroupRelation
type QueryFaceAllUserGroupAndDeviceGroupRelationRequest struct {
	*requests.RpcRequest
	IsolationId string           `position:"Query" name:"IsolationId"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	PageNo      requests.Integer `position:"Query" name:"PageNo"`
	ApiProduct  string           `position:"Body" name:"ApiProduct"`
	ApiRevision string           `position:"Body" name:"ApiRevision"`
}

// QueryFaceAllUserGroupAndDeviceGroupRelationResponse is the response struct for api QueryFaceAllUserGroupAndDeviceGroupRelation
type QueryFaceAllUserGroupAndDeviceGroupRelationResponse struct {
	*responses.BaseResponse
	Code         string `json:"Code" xml:"Code"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool   `json:"Success" xml:"Success"`
	Data         Data   `json:"Data" xml:"Data"`
}

// CreateQueryFaceAllUserGroupAndDeviceGroupRelationRequest creates a request to invoke QueryFaceAllUserGroupAndDeviceGroupRelation API
func CreateQueryFaceAllUserGroupAndDeviceGroupRelationRequest() (request *QueryFaceAllUserGroupAndDeviceGroupRelationRequest) {
	request = &QueryFaceAllUserGroupAndDeviceGroupRelationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Linkvisual", "2018-01-20", "QueryFaceAllUserGroupAndDeviceGroupRelation", "Linkvisual", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryFaceAllUserGroupAndDeviceGroupRelationResponse creates a response to parse from QueryFaceAllUserGroupAndDeviceGroupRelation response
func CreateQueryFaceAllUserGroupAndDeviceGroupRelationResponse() (response *QueryFaceAllUserGroupAndDeviceGroupRelationResponse) {
	response = &QueryFaceAllUserGroupAndDeviceGroupRelationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
