package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QuerySoundCodeLabelBatchFailedResult invokes the iot.QuerySoundCodeLabelBatchFailedResult API synchronously
func (client *Client) QuerySoundCodeLabelBatchFailedResult(request *QuerySoundCodeLabelBatchFailedResultRequest) (response *QuerySoundCodeLabelBatchFailedResultResponse, err error) {
	response = CreateQuerySoundCodeLabelBatchFailedResultResponse()
	err = client.DoAction(request, response)
	return
}

// QuerySoundCodeLabelBatchFailedResultWithChan invokes the iot.QuerySoundCodeLabelBatchFailedResult API asynchronously
func (client *Client) QuerySoundCodeLabelBatchFailedResultWithChan(request *QuerySoundCodeLabelBatchFailedResultRequest) (<-chan *QuerySoundCodeLabelBatchFailedResultResponse, <-chan error) {
	responseChan := make(chan *QuerySoundCodeLabelBatchFailedResultResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QuerySoundCodeLabelBatchFailedResult(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QuerySoundCodeLabelBatchFailedResultWithCallback invokes the iot.QuerySoundCodeLabelBatchFailedResult API asynchronously
func (client *Client) QuerySoundCodeLabelBatchFailedResultWithCallback(request *QuerySoundCodeLabelBatchFailedResultRequest, callback func(response *QuerySoundCodeLabelBatchFailedResultResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QuerySoundCodeLabelBatchFailedResultResponse
		var err error
		defer close(result)
		response, err = client.QuerySoundCodeLabelBatchFailedResult(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QuerySoundCodeLabelBatchFailedResultRequest is the request struct for api QuerySoundCodeLabelBatchFailedResult
type QuerySoundCodeLabelBatchFailedResultRequest struct {
	*requests.RpcRequest
	BatchCode     string `position:"Body" name:"BatchCode"`
	IotInstanceId string `position:"Body" name:"IotInstanceId"`
	ApiProduct    string `position:"Body" name:"ApiProduct"`
	ApiRevision   string `position:"Body" name:"ApiRevision"`
}

// QuerySoundCodeLabelBatchFailedResultResponse is the response struct for api QuerySoundCodeLabelBatchFailedResult
type QuerySoundCodeLabelBatchFailedResultResponse struct {
	*responses.BaseResponse
	RequestId    string                                     `json:"RequestId" xml:"RequestId"`
	Success      bool                                       `json:"Success" xml:"Success"`
	Code         string                                     `json:"Code" xml:"Code"`
	ErrorMessage string                                     `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         DataInQuerySoundCodeLabelBatchFailedResult `json:"Data" xml:"Data"`
}

// CreateQuerySoundCodeLabelBatchFailedResultRequest creates a request to invoke QuerySoundCodeLabelBatchFailedResult API
func CreateQuerySoundCodeLabelBatchFailedResultRequest() (request *QuerySoundCodeLabelBatchFailedResultRequest) {
	request = &QuerySoundCodeLabelBatchFailedResultRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "QuerySoundCodeLabelBatchFailedResult", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQuerySoundCodeLabelBatchFailedResultResponse creates a response to parse from QuerySoundCodeLabelBatchFailedResult response
func CreateQuerySoundCodeLabelBatchFailedResultResponse() (response *QuerySoundCodeLabelBatchFailedResultResponse) {
	response = &QuerySoundCodeLabelBatchFailedResultResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
