package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteDeviceTunnel invokes the iot.DeleteDeviceTunnel API synchronously
func (client *Client) DeleteDeviceTunnel(request *DeleteDeviceTunnelRequest) (response *DeleteDeviceTunnelResponse, err error) {
	response = CreateDeleteDeviceTunnelResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteDeviceTunnelWithChan invokes the iot.DeleteDeviceTunnel API asynchronously
func (client *Client) DeleteDeviceTunnelWithChan(request *DeleteDeviceTunnelRequest) (<-chan *DeleteDeviceTunnelResponse, <-chan error) {
	responseChan := make(chan *DeleteDeviceTunnelResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteDeviceTunnel(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteDeviceTunnelWithCallback invokes the iot.DeleteDeviceTunnel API asynchronously
func (client *Client) DeleteDeviceTunnelWithCallback(request *DeleteDeviceTunnelRequest, callback func(response *DeleteDeviceTunnelResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteDeviceTunnelResponse
		var err error
		defer close(result)
		response, err = client.DeleteDeviceTunnel(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteDeviceTunnelRequest is the request struct for api DeleteDeviceTunnel
type DeleteDeviceTunnelRequest struct {
	*requests.RpcRequest
	IotInstanceId string `position:"Query" name:"IotInstanceId"`
	TunnelId      string `position:"Query" name:"TunnelId"`
	ApiProduct    string `position:"Body" name:"ApiProduct"`
	ApiRevision   string `position:"Body" name:"ApiRevision"`
}

// DeleteDeviceTunnelResponse is the response struct for api DeleteDeviceTunnel
type DeleteDeviceTunnelResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
}

// CreateDeleteDeviceTunnelRequest creates a request to invoke DeleteDeviceTunnel API
func CreateDeleteDeviceTunnelRequest() (request *DeleteDeviceTunnelRequest) {
	request = &DeleteDeviceTunnelRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "DeleteDeviceTunnel", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteDeviceTunnelResponse creates a response to parse from DeleteDeviceTunnel response
func CreateDeleteDeviceTunnelResponse() (response *DeleteDeviceTunnelResponse) {
	response = &DeleteDeviceTunnelResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
