package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateDeviceDynamicGroup invokes the iot.CreateDeviceDynamicGroup API synchronously
func (client *Client) CreateDeviceDynamicGroup(request *CreateDeviceDynamicGroupRequest) (response *CreateDeviceDynamicGroupResponse, err error) {
	response = CreateCreateDeviceDynamicGroupResponse()
	err = client.DoAction(request, response)
	return
}

// CreateDeviceDynamicGroupWithChan invokes the iot.CreateDeviceDynamicGroup API asynchronously
func (client *Client) CreateDeviceDynamicGroupWithChan(request *CreateDeviceDynamicGroupRequest) (<-chan *CreateDeviceDynamicGroupResponse, <-chan error) {
	responseChan := make(chan *CreateDeviceDynamicGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateDeviceDynamicGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateDeviceDynamicGroupWithCallback invokes the iot.CreateDeviceDynamicGroup API asynchronously
func (client *Client) CreateDeviceDynamicGroupWithCallback(request *CreateDeviceDynamicGroupRequest, callback func(response *CreateDeviceDynamicGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateDeviceDynamicGroupResponse
		var err error
		defer close(result)
		response, err = client.CreateDeviceDynamicGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateDeviceDynamicGroupRequest is the request struct for api CreateDeviceDynamicGroup
type CreateDeviceDynamicGroupRequest struct {
	*requests.RpcRequest
	DynamicGroupExpression string `position:"Query" name:"DynamicGroupExpression"`
	IotInstanceId          string `position:"Query" name:"IotInstanceId"`
	GroupName              string `position:"Query" name:"GroupName"`
	GroupDesc              string `position:"Query" name:"GroupDesc"`
	ApiProduct             string `position:"Body" name:"ApiProduct"`
	ApiRevision            string `position:"Body" name:"ApiRevision"`
}

// CreateDeviceDynamicGroupResponse is the response struct for api CreateDeviceDynamicGroup
type CreateDeviceDynamicGroupResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         Data   `json:"Data" xml:"Data"`
}

// CreateCreateDeviceDynamicGroupRequest creates a request to invoke CreateDeviceDynamicGroup API
func CreateCreateDeviceDynamicGroupRequest() (request *CreateDeviceDynamicGroupRequest) {
	request = &CreateDeviceDynamicGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "CreateDeviceDynamicGroup", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateDeviceDynamicGroupResponse creates a response to parse from CreateDeviceDynamicGroup response
func CreateCreateDeviceDynamicGroupResponse() (response *CreateDeviceDynamicGroupResponse) {
	response = &CreateDeviceDynamicGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
