package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CheckBindLicenseDeviceProgress invokes the iot.CheckBindLicenseDeviceProgress API synchronously
func (client *Client) CheckBindLicenseDeviceProgress(request *CheckBindLicenseDeviceProgressRequest) (response *CheckBindLicenseDeviceProgressResponse, err error) {
	response = CreateCheckBindLicenseDeviceProgressResponse()
	err = client.DoAction(request, response)
	return
}

// CheckBindLicenseDeviceProgressWithChan invokes the iot.CheckBindLicenseDeviceProgress API asynchronously
func (client *Client) CheckBindLicenseDeviceProgressWithChan(request *CheckBindLicenseDeviceProgressRequest) (<-chan *CheckBindLicenseDeviceProgressResponse, <-chan error) {
	responseChan := make(chan *CheckBindLicenseDeviceProgressResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CheckBindLicenseDeviceProgress(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CheckBindLicenseDeviceProgressWithCallback invokes the iot.CheckBindLicenseDeviceProgress API asynchronously
func (client *Client) CheckBindLicenseDeviceProgressWithCallback(request *CheckBindLicenseDeviceProgressRequest, callback func(response *CheckBindLicenseDeviceProgressResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CheckBindLicenseDeviceProgressResponse
		var err error
		defer close(result)
		response, err = client.CheckBindLicenseDeviceProgress(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CheckBindLicenseDeviceProgressRequest is the request struct for api CheckBindLicenseDeviceProgress
type CheckBindLicenseDeviceProgressRequest struct {
	*requests.RpcRequest
	CheckProgressId string `position:"Query" name:"CheckProgressId"`
	IotInstanceId   string `position:"Query" name:"IotInstanceId"`
	ProductKey      string `position:"Query" name:"ProductKey"`
	ApiProduct      string `position:"Body" name:"ApiProduct"`
	ApiRevision     string `position:"Body" name:"ApiRevision"`
	LicenseCode     string `position:"Query" name:"LicenseCode"`
}

// CheckBindLicenseDeviceProgressResponse is the response struct for api CheckBindLicenseDeviceProgress
type CheckBindLicenseDeviceProgressResponse struct {
	*responses.BaseResponse
	RequestId    string                               `json:"RequestId" xml:"RequestId"`
	Success      bool                                 `json:"Success" xml:"Success"`
	Code         string                               `json:"Code" xml:"Code"`
	ErrorMessage string                               `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         DataInCheckBindLicenseDeviceProgress `json:"Data" xml:"Data"`
}

// CreateCheckBindLicenseDeviceProgressRequest creates a request to invoke CheckBindLicenseDeviceProgress API
func CreateCheckBindLicenseDeviceProgressRequest() (request *CheckBindLicenseDeviceProgressRequest) {
	request = &CheckBindLicenseDeviceProgressRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "CheckBindLicenseDeviceProgress", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCheckBindLicenseDeviceProgressResponse creates a response to parse from CheckBindLicenseDeviceProgress response
func CreateCheckBindLicenseDeviceProgressResponse() (response *CheckBindLicenseDeviceProgressResponse) {
	response = &CheckBindLicenseDeviceProgressResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
