package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchGrayMigrationDevice invokes the iot.BatchGrayMigrationDevice API synchronously
func (client *Client) BatchGrayMigrationDevice(request *BatchGrayMigrationDeviceRequest) (response *BatchGrayMigrationDeviceResponse, err error) {
	response = CreateBatchGrayMigrationDeviceResponse()
	err = client.DoAction(request, response)
	return
}

// BatchGrayMigrationDeviceWithChan invokes the iot.BatchGrayMigrationDevice API asynchronously
func (client *Client) BatchGrayMigrationDeviceWithChan(request *BatchGrayMigrationDeviceRequest) (<-chan *BatchGrayMigrationDeviceResponse, <-chan error) {
	responseChan := make(chan *BatchGrayMigrationDeviceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchGrayMigrationDevice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchGrayMigrationDeviceWithCallback invokes the iot.BatchGrayMigrationDevice API asynchronously
func (client *Client) BatchGrayMigrationDeviceWithCallback(request *BatchGrayMigrationDeviceRequest, callback func(response *BatchGrayMigrationDeviceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchGrayMigrationDeviceResponse
		var err error
		defer close(result)
		response, err = client.BatchGrayMigrationDevice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchGrayMigrationDeviceRequest is the request struct for api BatchGrayMigrationDevice
type BatchGrayMigrationDeviceRequest struct {
	*requests.RpcRequest
	DeviceNames *[]string `position:"Body" name:"DeviceNames"  type:"Repeated"`
	ProductKey  string    `position:"Query" name:"ProductKey"`
	ApiProduct  string    `position:"Body" name:"ApiProduct"`
	ApiRevision string    `position:"Body" name:"ApiRevision"`
}

// BatchGrayMigrationDeviceResponse is the response struct for api BatchGrayMigrationDevice
type BatchGrayMigrationDeviceResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         Data   `json:"Data" xml:"Data"`
}

// CreateBatchGrayMigrationDeviceRequest creates a request to invoke BatchGrayMigrationDevice API
func CreateBatchGrayMigrationDeviceRequest() (request *BatchGrayMigrationDeviceRequest) {
	request = &BatchGrayMigrationDeviceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "BatchGrayMigrationDevice", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateBatchGrayMigrationDeviceResponse creates a response to parse from BatchGrayMigrationDevice response
func CreateBatchGrayMigrationDeviceResponse() (response *BatchGrayMigrationDeviceResponse) {
	response = &BatchGrayMigrationDeviceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
