package imageseg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SegmentHDCommonImage invokes the imageseg.SegmentHDCommonImage API synchronously
func (client *Client) SegmentHDCommonImage(request *SegmentHDCommonImageRequest) (response *SegmentHDCommonImageResponse, err error) {
	response = CreateSegmentHDCommonImageResponse()
	err = client.DoAction(request, response)
	return
}

// SegmentHDCommonImageWithChan invokes the imageseg.SegmentHDCommonImage API asynchronously
func (client *Client) SegmentHDCommonImageWithChan(request *SegmentHDCommonImageRequest) (<-chan *SegmentHDCommonImageResponse, <-chan error) {
	responseChan := make(chan *SegmentHDCommonImageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SegmentHDCommonImage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SegmentHDCommonImageWithCallback invokes the imageseg.SegmentHDCommonImage API asynchronously
func (client *Client) SegmentHDCommonImageWithCallback(request *SegmentHDCommonImageRequest, callback func(response *SegmentHDCommonImageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SegmentHDCommonImageResponse
		var err error
		defer close(result)
		response, err = client.SegmentHDCommonImage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SegmentHDCommonImageRequest is the request struct for api SegmentHDCommonImage
type SegmentHDCommonImageRequest struct {
	*requests.RpcRequest
	OssFile        string           `position:"Query" name:"OssFile"`
	RequestProxyBy string           `position:"Query" name:"RequestProxyBy"`
	Async          requests.Boolean `position:"Body" name:"Async"`
	ImageUrl       string           `position:"Body" name:"ImageUrl"`
}

// SegmentHDCommonImageResponse is the response struct for api SegmentHDCommonImage
type SegmentHDCommonImageResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateSegmentHDCommonImageRequest creates a request to invoke SegmentHDCommonImage API
func CreateSegmentHDCommonImageRequest() (request *SegmentHDCommonImageRequest) {
	request = &SegmentHDCommonImageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imageseg", "2019-12-30", "SegmentHDCommonImage", "imageseg", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSegmentHDCommonImageResponse creates a response to parse from SegmentHDCommonImage response
func CreateSegmentHDCommonImageResponse() (response *SegmentHDCommonImageResponse) {
	response = &SegmentHDCommonImageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
