package imageprocess

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DetectSkinDisease invokes the imageprocess.DetectSkinDisease API synchronously
func (client *Client) DetectSkinDisease(request *DetectSkinDiseaseRequest) (response *DetectSkinDiseaseResponse, err error) {
	response = CreateDetectSkinDiseaseResponse()
	err = client.DoAction(request, response)
	return
}

// DetectSkinDiseaseWithChan invokes the imageprocess.DetectSkinDisease API asynchronously
func (client *Client) DetectSkinDiseaseWithChan(request *DetectSkinDiseaseRequest) (<-chan *DetectSkinDiseaseResponse, <-chan error) {
	responseChan := make(chan *DetectSkinDiseaseResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DetectSkinDisease(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DetectSkinDiseaseWithCallback invokes the imageprocess.DetectSkinDisease API asynchronously
func (client *Client) DetectSkinDiseaseWithCallback(request *DetectSkinDiseaseRequest, callback func(response *DetectSkinDiseaseResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DetectSkinDiseaseResponse
		var err error
		defer close(result)
		response, err = client.DetectSkinDisease(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DetectSkinDiseaseRequest is the request struct for api DetectSkinDisease
type DetectSkinDiseaseRequest struct {
	*requests.RpcRequest
	OrgName string `position:"Body" name:"OrgName"`
	Url     string `position:"Body" name:"Url"`
	OrgId   string `position:"Body" name:"OrgId"`
}

// DetectSkinDiseaseResponse is the response struct for api DetectSkinDisease
type DetectSkinDiseaseResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDetectSkinDiseaseRequest creates a request to invoke DetectSkinDisease API
func CreateDetectSkinDiseaseRequest() (request *DetectSkinDiseaseRequest) {
	request = &DetectSkinDiseaseRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imageprocess", "2020-03-20", "DetectSkinDisease", "imageprocess", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDetectSkinDiseaseResponse creates a response to parse from DetectSkinDisease response
func CreateDetectSkinDiseaseResponse() (response *DetectSkinDiseaseResponse) {
	response = &DetectSkinDiseaseResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
