package hitsdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetLindormInstanceEngineList invokes the hitsdb.GetLindormInstanceEngineList API synchronously
func (client *Client) GetLindormInstanceEngineList(request *GetLindormInstanceEngineListRequest) (response *GetLindormInstanceEngineListResponse, err error) {
	response = CreateGetLindormInstanceEngineListResponse()
	err = client.DoAction(request, response)
	return
}

// GetLindormInstanceEngineListWithChan invokes the hitsdb.GetLindormInstanceEngineList API asynchronously
func (client *Client) GetLindormInstanceEngineListWithChan(request *GetLindormInstanceEngineListRequest) (<-chan *GetLindormInstanceEngineListResponse, <-chan error) {
	responseChan := make(chan *GetLindormInstanceEngineListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetLindormInstanceEngineList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetLindormInstanceEngineListWithCallback invokes the hitsdb.GetLindormInstanceEngineList API asynchronously
func (client *Client) GetLindormInstanceEngineListWithCallback(request *GetLindormInstanceEngineListRequest, callback func(response *GetLindormInstanceEngineListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetLindormInstanceEngineListResponse
		var err error
		defer close(result)
		response, err = client.GetLindormInstanceEngineList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetLindormInstanceEngineListRequest is the request struct for api GetLindormInstanceEngineList
type GetLindormInstanceEngineListRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	InstanceId           string           `position:"Query" name:"InstanceId"`
}

// GetLindormInstanceEngineListResponse is the response struct for api GetLindormInstanceEngineList
type GetLindormInstanceEngineListResponse struct {
	*responses.BaseResponse
	InstanceId string       `json:"InstanceId" xml:"InstanceId"`
	RequestId  string       `json:"RequestId" xml:"RequestId"`
	EngineList []EngineInfo `json:"EngineList" xml:"EngineList"`
}

// CreateGetLindormInstanceEngineListRequest creates a request to invoke GetLindormInstanceEngineList API
func CreateGetLindormInstanceEngineListRequest() (request *GetLindormInstanceEngineListRequest) {
	request = &GetLindormInstanceEngineListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("hitsdb", "2020-06-15", "GetLindormInstanceEngineList", "hitsdb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetLindormInstanceEngineListResponse creates a response to parse from GetLindormInstanceEngineList response
func CreateGetLindormInstanceEngineListResponse() (response *GetLindormInstanceEngineListResponse) {
	response = &GetLindormInstanceEngineListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
