package hbase

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyInstanceServiceConfig invokes the hbase.ModifyInstanceServiceConfig API synchronously
func (client *Client) ModifyInstanceServiceConfig(request *ModifyInstanceServiceConfigRequest) (response *ModifyInstanceServiceConfigResponse, err error) {
	response = CreateModifyInstanceServiceConfigResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyInstanceServiceConfigWithChan invokes the hbase.ModifyInstanceServiceConfig API asynchronously
func (client *Client) ModifyInstanceServiceConfigWithChan(request *ModifyInstanceServiceConfigRequest) (<-chan *ModifyInstanceServiceConfigResponse, <-chan error) {
	responseChan := make(chan *ModifyInstanceServiceConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyInstanceServiceConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyInstanceServiceConfigWithCallback invokes the hbase.ModifyInstanceServiceConfig API asynchronously
func (client *Client) ModifyInstanceServiceConfigWithCallback(request *ModifyInstanceServiceConfigRequest, callback func(response *ModifyInstanceServiceConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyInstanceServiceConfigResponse
		var err error
		defer close(result)
		response, err = client.ModifyInstanceServiceConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyInstanceServiceConfigRequest is the request struct for api ModifyInstanceServiceConfig
type ModifyInstanceServiceConfigRequest struct {
	*requests.RpcRequest
	ConfigureName  string           `position:"Query" name:"ConfigureName"`
	Restart        requests.Boolean `position:"Query" name:"Restart"`
	ClusterId      string           `position:"Query" name:"ClusterId"`
	ConfigureValue string           `position:"Query" name:"ConfigureValue"`
	Parameters     string           `position:"Query" name:"Parameters"`
}

// ModifyInstanceServiceConfigResponse is the response struct for api ModifyInstanceServiceConfig
type ModifyInstanceServiceConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyInstanceServiceConfigRequest creates a request to invoke ModifyInstanceServiceConfig API
func CreateModifyInstanceServiceConfigRequest() (request *ModifyInstanceServiceConfigRequest) {
	request = &ModifyInstanceServiceConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("HBase", "2019-01-01", "ModifyInstanceServiceConfig", "hbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyInstanceServiceConfigResponse creates a response to parse from ModifyInstanceServiceConfig response
func CreateModifyInstanceServiceConfigResponse() (response *ModifyInstanceServiceConfigResponse) {
	response = &ModifyInstanceServiceConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
