package gpdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeWaitingSQLRecords invokes the gpdb.DescribeWaitingSQLRecords API synchronously
func (client *Client) DescribeWaitingSQLRecords(request *DescribeWaitingSQLRecordsRequest) (response *DescribeWaitingSQLRecordsResponse, err error) {
	response = CreateDescribeWaitingSQLRecordsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeWaitingSQLRecordsWithChan invokes the gpdb.DescribeWaitingSQLRecords API asynchronously
func (client *Client) DescribeWaitingSQLRecordsWithChan(request *DescribeWaitingSQLRecordsRequest) (<-chan *DescribeWaitingSQLRecordsResponse, <-chan error) {
	responseChan := make(chan *DescribeWaitingSQLRecordsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeWaitingSQLRecords(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeWaitingSQLRecordsWithCallback invokes the gpdb.DescribeWaitingSQLRecords API asynchronously
func (client *Client) DescribeWaitingSQLRecordsWithCallback(request *DescribeWaitingSQLRecordsRequest, callback func(response *DescribeWaitingSQLRecordsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeWaitingSQLRecordsResponse
		var err error
		defer close(result)
		response, err = client.DescribeWaitingSQLRecords(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeWaitingSQLRecordsRequest is the request struct for api DescribeWaitingSQLRecords
type DescribeWaitingSQLRecordsRequest struct {
	*requests.RpcRequest
	QueryCondition string           `position:"Query" name:"QueryCondition"`
	StartTime      string           `position:"Query" name:"StartTime"`
	PageNumber     requests.Integer `position:"Query" name:"PageNumber"`
	Database       string           `position:"Query" name:"Database"`
	PageSize       requests.Integer `position:"Query" name:"PageSize"`
	DBInstanceId   string           `position:"Query" name:"DBInstanceId"`
	Keyword        string           `position:"Query" name:"Keyword"`
	Order          string           `position:"Query" name:"Order"`
	EndTime        string           `position:"Query" name:"EndTime"`
	User           string           `position:"Query" name:"User"`
}

// DescribeWaitingSQLRecordsResponse is the response struct for api DescribeWaitingSQLRecords
type DescribeWaitingSQLRecordsResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	TotalCount int    `json:"TotalCount" xml:"TotalCount"`
	PageNumber int    `json:"PageNumber" xml:"PageNumber"`
	Items      []Item `json:"Items" xml:"Items"`
}

// CreateDescribeWaitingSQLRecordsRequest creates a request to invoke DescribeWaitingSQLRecords API
func CreateDescribeWaitingSQLRecordsRequest() (request *DescribeWaitingSQLRecordsRequest) {
	request = &DescribeWaitingSQLRecordsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("gpdb", "2016-05-03", "DescribeWaitingSQLRecords", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeWaitingSQLRecordsResponse creates a response to parse from DescribeWaitingSQLRecords response
func CreateDescribeWaitingSQLRecordsResponse() (response *DescribeWaitingSQLRecordsResponse) {
	response = &DescribeWaitingSQLRecordsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
