package governance

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListEvaluationMetadata invokes the governance.ListEvaluationMetadata API synchronously
func (client *Client) ListEvaluationMetadata(request *ListEvaluationMetadataRequest) (response *ListEvaluationMetadataResponse, err error) {
	response = CreateListEvaluationMetadataResponse()
	err = client.DoAction(request, response)
	return
}

// ListEvaluationMetadataWithChan invokes the governance.ListEvaluationMetadata API asynchronously
func (client *Client) ListEvaluationMetadataWithChan(request *ListEvaluationMetadataRequest) (<-chan *ListEvaluationMetadataResponse, <-chan error) {
	responseChan := make(chan *ListEvaluationMetadataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListEvaluationMetadata(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListEvaluationMetadataWithCallback invokes the governance.ListEvaluationMetadata API asynchronously
func (client *Client) ListEvaluationMetadataWithCallback(request *ListEvaluationMetadataRequest, callback func(response *ListEvaluationMetadataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListEvaluationMetadataResponse
		var err error
		defer close(result)
		response, err = client.ListEvaluationMetadata(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListEvaluationMetadataRequest is the request struct for api ListEvaluationMetadata
type ListEvaluationMetadataRequest struct {
	*requests.RpcRequest
	Language    string `position:"Query" name:"Language"`
	PartnerCode string `position:"Query" name:"PartnerCode"`
}

// ListEvaluationMetadataResponse is the response struct for api ListEvaluationMetadata
type ListEvaluationMetadataResponse struct {
	*responses.BaseResponse
	RequestId          string                   `json:"RequestId" xml:"RequestId"`
	EvaluationMetadata []EvaluationMetadataItem `json:"EvaluationMetadata" xml:"EvaluationMetadata"`
}

// CreateListEvaluationMetadataRequest creates a request to invoke ListEvaluationMetadata API
func CreateListEvaluationMetadataRequest() (request *ListEvaluationMetadataRequest) {
	request = &ListEvaluationMetadataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("governance", "2021-01-20", "ListEvaluationMetadata", "governance", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListEvaluationMetadataResponse creates a response to parse from ListEvaluationMetadata response
func CreateListEvaluationMetadataResponse() (response *ListEvaluationMetadataResponse) {
	response = &ListEvaluationMetadataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
