package ga

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeBandwidthPackage invokes the ga.DescribeBandwidthPackage API synchronously
func (client *Client) DescribeBandwidthPackage(request *DescribeBandwidthPackageRequest) (response *DescribeBandwidthPackageResponse, err error) {
	response = CreateDescribeBandwidthPackageResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeBandwidthPackageWithChan invokes the ga.DescribeBandwidthPackage API asynchronously
func (client *Client) DescribeBandwidthPackageWithChan(request *DescribeBandwidthPackageRequest) (<-chan *DescribeBandwidthPackageResponse, <-chan error) {
	responseChan := make(chan *DescribeBandwidthPackageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeBandwidthPackage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeBandwidthPackageWithCallback invokes the ga.DescribeBandwidthPackage API asynchronously
func (client *Client) DescribeBandwidthPackageWithCallback(request *DescribeBandwidthPackageRequest, callback func(response *DescribeBandwidthPackageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeBandwidthPackageResponse
		var err error
		defer close(result)
		response, err = client.DescribeBandwidthPackage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeBandwidthPackageRequest is the request struct for api DescribeBandwidthPackage
type DescribeBandwidthPackageRequest struct {
	*requests.RpcRequest
	BandwidthPackageId string `position:"Query" name:"BandwidthPackageId"`
}

// DescribeBandwidthPackageResponse is the response struct for api DescribeBandwidthPackage
type DescribeBandwidthPackageResponse struct {
	*responses.BaseResponse
	CbnGeographicRegionIdB string   `json:"CbnGeographicRegionIdB" xml:"CbnGeographicRegionIdB"`
	Description            string   `json:"Description" xml:"Description"`
	CbnGeographicRegionIdA string   `json:"CbnGeographicRegionIdA" xml:"CbnGeographicRegionIdA"`
	RequestId              string   `json:"RequestId" xml:"RequestId"`
	CreateTime             string   `json:"CreateTime" xml:"CreateTime"`
	Name                   string   `json:"Name" xml:"Name"`
	BandwidthType          string   `json:"BandwidthType" xml:"BandwidthType"`
	Type                   string   `json:"Type" xml:"Type"`
	ChargeType             string   `json:"ChargeType" xml:"ChargeType"`
	State                  string   `json:"State" xml:"State"`
	ExpiredTime            string   `json:"ExpiredTime" xml:"ExpiredTime"`
	Bandwidth              int      `json:"Bandwidth" xml:"Bandwidth"`
	BandwidthPackageId     string   `json:"BandwidthPackageId" xml:"BandwidthPackageId"`
	Ratio                  int      `json:"Ratio" xml:"Ratio"`
	RegionId               string   `json:"RegionId" xml:"RegionId"`
	BillingType            string   `json:"BillingType" xml:"BillingType"`
	Accelerators           []string `json:"Accelerators" xml:"Accelerators"`
}

// CreateDescribeBandwidthPackageRequest creates a request to invoke DescribeBandwidthPackage API
func CreateDescribeBandwidthPackageRequest() (request *DescribeBandwidthPackageRequest) {
	request = &DescribeBandwidthPackageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ga", "2019-11-20", "DescribeBandwidthPackage", "gaplus", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeBandwidthPackageResponse creates a response to parse from DescribeBandwidthPackage response
func CreateDescribeBandwidthPackageResponse() (response *DescribeBandwidthPackageResponse) {
	response = &DescribeBandwidthPackageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
