package facebody

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeepfakeFace invokes the facebody.DeepfakeFace API synchronously
func (client *Client) DeepfakeFace(request *DeepfakeFaceRequest) (response *DeepfakeFaceResponse, err error) {
	response = CreateDeepfakeFaceResponse()
	err = client.DoAction(request, response)
	return
}

// DeepfakeFaceWithChan invokes the facebody.DeepfakeFace API asynchronously
func (client *Client) DeepfakeFaceWithChan(request *DeepfakeFaceRequest) (<-chan *DeepfakeFaceResponse, <-chan error) {
	responseChan := make(chan *DeepfakeFaceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeepfakeFace(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeepfakeFaceWithCallback invokes the facebody.DeepfakeFace API asynchronously
func (client *Client) DeepfakeFaceWithCallback(request *DeepfakeFaceRequest, callback func(response *DeepfakeFaceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeepfakeFaceResponse
		var err error
		defer close(result)
		response, err = client.DeepfakeFace(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeepfakeFaceRequest is the request struct for api DeepfakeFace
type DeepfakeFaceRequest struct {
	*requests.RpcRequest
	FormatResultToJson requests.Boolean     `position:"Query" name:"FormatResultToJson"`
	OssFile            string               `position:"Query" name:"OssFile"`
	Tasks              *[]DeepfakeFaceTasks `position:"Body" name:"Tasks"  type:"Repeated"`
	RequestProxyBy     string               `position:"Query" name:"RequestProxyBy"`
}

// DeepfakeFaceTasks is a repeated param struct in DeepfakeFaceRequest
type DeepfakeFaceTasks struct {
	ImageURL  string `name:"ImageURL"`
	ImageData string `name:"ImageData"`
}

// DeepfakeFaceResponse is the response struct for api DeepfakeFace
type DeepfakeFaceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDeepfakeFaceRequest creates a request to invoke DeepfakeFace API
func CreateDeepfakeFaceRequest() (request *DeepfakeFaceRequest) {
	request = &DeepfakeFaceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("facebody", "2019-12-30", "DeepfakeFace", "facebody", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeepfakeFaceResponse creates a response to parse from DeepfakeFace response
func CreateDeepfakeFaceResponse() (response *DeepfakeFaceResponse) {
	response = &DeepfakeFaceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
