package eventbridge

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateApiDestination invokes the eventbridge.UpdateApiDestination API synchronously
func (client *Client) UpdateApiDestination(request *UpdateApiDestinationRequest) (response *UpdateApiDestinationResponse, err error) {
	response = CreateUpdateApiDestinationResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateApiDestinationWithChan invokes the eventbridge.UpdateApiDestination API asynchronously
func (client *Client) UpdateApiDestinationWithChan(request *UpdateApiDestinationRequest) (<-chan *UpdateApiDestinationResponse, <-chan error) {
	responseChan := make(chan *UpdateApiDestinationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateApiDestination(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateApiDestinationWithCallback invokes the eventbridge.UpdateApiDestination API asynchronously
func (client *Client) UpdateApiDestinationWithCallback(request *UpdateApiDestinationRequest, callback func(response *UpdateApiDestinationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateApiDestinationResponse
		var err error
		defer close(result)
		response, err = client.UpdateApiDestination(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateApiDestinationRequest is the request struct for api UpdateApiDestination
type UpdateApiDestinationRequest struct {
	*requests.RpcRequest
	ClientToken                  string                                `position:"Query" name:"ClientToken"`
	Description                  string                                `position:"Query" name:"Description"`
	ApiDestinationName           string                                `position:"Query" name:"ApiDestinationName"`
	ConnectionName               string                                `position:"Query" name:"ConnectionName"`
	HttpApiParameters            UpdateApiDestinationHttpApiParameters `position:"Query" name:"HttpApiParameters"  type:"Struct"`
	InvocationRateLimitPerSecond requests.Integer                      `position:"Query" name:"InvocationRateLimitPerSecond"`
}

// UpdateApiDestinationHttpApiParameters is a repeated param struct in UpdateApiDestinationRequest
type UpdateApiDestinationHttpApiParameters struct {
	Endpoint      string                                                    `name:"Endpoint"`
	Method        string                                                    `name:"Method"`
	ApiParameters *[]UpdateApiDestinationHttpApiParametersApiParametersItem `name:"ApiParameters" type:"Repeated"`
}

// UpdateApiDestinationHttpApiParametersApiParametersItem is a repeated param struct in UpdateApiDestinationRequest
type UpdateApiDestinationHttpApiParametersApiParametersItem struct {
	In           string `name:"In"`
	Name         string `name:"Name"`
	Description  string `name:"Description"`
	DefaultValue string `name:"DefaultValue"`
	Type         string `name:"Type"`
}

// UpdateApiDestinationResponse is the response struct for api UpdateApiDestination
type UpdateApiDestinationResponse struct {
	*responses.BaseResponse
	RequestId          string `json:"RequestId" xml:"RequestId"`
	Message            string `json:"Message" xml:"Message"`
	Code               string `json:"Code" xml:"Code"`
	ApiDestinationName string `json:"ApiDestinationName" xml:"ApiDestinationName"`
}

// CreateUpdateApiDestinationRequest creates a request to invoke UpdateApiDestination API
func CreateUpdateApiDestinationRequest() (request *UpdateApiDestinationRequest) {
	request = &UpdateApiDestinationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eventbridge", "2020-04-01", "UpdateApiDestination", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateApiDestinationResponse creates a response to parse from UpdateApiDestination response
func CreateUpdateApiDestinationResponse() (response *UpdateApiDestinationResponse) {
	response = &UpdateApiDestinationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
