package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StartEpnInstance invokes the ens.StartEpnInstance API synchronously
func (client *Client) StartEpnInstance(request *StartEpnInstanceRequest) (response *StartEpnInstanceResponse, err error) {
	response = CreateStartEpnInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// StartEpnInstanceWithChan invokes the ens.StartEpnInstance API asynchronously
func (client *Client) StartEpnInstanceWithChan(request *StartEpnInstanceRequest) (<-chan *StartEpnInstanceResponse, <-chan error) {
	responseChan := make(chan *StartEpnInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StartEpnInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StartEpnInstanceWithCallback invokes the ens.StartEpnInstance API asynchronously
func (client *Client) StartEpnInstanceWithCallback(request *StartEpnInstanceRequest, callback func(response *StartEpnInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StartEpnInstanceResponse
		var err error
		defer close(result)
		response, err = client.StartEpnInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StartEpnInstanceRequest is the request struct for api StartEpnInstance
type StartEpnInstanceRequest struct {
	*requests.RpcRequest
	EPNInstanceId string `position:"Query" name:"EPNInstanceId"`
}

// StartEpnInstanceResponse is the response struct for api StartEpnInstance
type StartEpnInstanceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateStartEpnInstanceRequest creates a request to invoke StartEpnInstance API
func CreateStartEpnInstanceRequest() (request *StartEpnInstanceRequest) {
	request = &StartEpnInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "StartEpnInstance", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateStartEpnInstanceResponse creates a response to parse from StartEpnInstance response
func CreateStartEpnInstanceResponse() (response *StartEpnInstanceResponse) {
	response = &StartEpnInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
