package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyNetworkAttribute invokes the ens.ModifyNetworkAttribute API synchronously
func (client *Client) ModifyNetworkAttribute(request *ModifyNetworkAttributeRequest) (response *ModifyNetworkAttributeResponse, err error) {
	response = CreateModifyNetworkAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyNetworkAttributeWithChan invokes the ens.ModifyNetworkAttribute API asynchronously
func (client *Client) ModifyNetworkAttributeWithChan(request *ModifyNetworkAttributeRequest) (<-chan *ModifyNetworkAttributeResponse, <-chan error) {
	responseChan := make(chan *ModifyNetworkAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyNetworkAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyNetworkAttributeWithCallback invokes the ens.ModifyNetworkAttribute API asynchronously
func (client *Client) ModifyNetworkAttributeWithCallback(request *ModifyNetworkAttributeRequest, callback func(response *ModifyNetworkAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyNetworkAttributeResponse
		var err error
		defer close(result)
		response, err = client.ModifyNetworkAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyNetworkAttributeRequest is the request struct for api ModifyNetworkAttribute
type ModifyNetworkAttributeRequest struct {
	*requests.RpcRequest
	Description string `position:"Query" name:"Description"`
	NetworkName string `position:"Query" name:"NetworkName"`
	NetworkId   string `position:"Query" name:"NetworkId"`
}

// ModifyNetworkAttributeResponse is the response struct for api ModifyNetworkAttribute
type ModifyNetworkAttributeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyNetworkAttributeRequest creates a request to invoke ModifyNetworkAttribute API
func CreateModifyNetworkAttributeRequest() (request *ModifyNetworkAttributeRequest) {
	request = &ModifyNetworkAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "ModifyNetworkAttribute", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyNetworkAttributeResponse creates a response to parse from ModifyNetworkAttribute response
func CreateModifyNetworkAttributeResponse() (response *ModifyNetworkAttributeResponse) {
	response = &ModifyNetworkAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
